<?php

use Elementor\Icons_Manager;

// Icon
$icon_html = $icon_array = '';
$custom_icon_enabled = get_post_meta( get_the_ID(), 'dsvy-custom-icon-enabled', true );
if( $custom_icon_enabled=='1' ){
	$img_src = '';
	$custom_icon_url = get_post_meta( get_the_ID(), 'dsvy-custom-icon', true );
	if( !empty($custom_icon_url) ){
		$img_src = wp_get_attachment_image_src($custom_icon_url, 'full');
		if( !empty($img_src[0]) ){ $custom_icon_url = $img_src[0]; }
	}
	$icon_html = '<img src="'.$custom_icon_url.'"/>';
}else{
	$icon_lib = get_post_meta( get_the_ID(), 'dsvy-service-icon-library', true );
	wp_enqueue_style($icon_lib);
	$icon_class = get_post_meta( get_the_ID(), 'dsvy-service-icon-'.$icon_lib, true );

	// icon library name for the function
	$icon_lib2 = $icon_lib;
	if( $icon_lib == 'elementor-icons-fa-regular' ){
		$icon_lib2 = 'fa-regular';
	} else if( $icon_lib == 'elementor-icons-fa-solid' ){
		$icon_lib2 = 'fa-solid';
	} else if( $icon_lib == 'elementor-icons-fa-brands' ){
		$icon_lib2 = 'fa-brands';
	}
	$icon_array = array(
		'value' => $icon_class,
		'library' => $icon_lib2,
	);
}

// Read More text
if( !isset($more_text) ){
	$more_text = esc_attr__('More','karzo');
}

// featured image src only
$img_src = '';
if ( has_post_thumbnail( get_the_ID() ) ) {
	$img_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID()), 'full' );
};

?>
<div class="designervily-post-item d-flex">
	<div class="designervily-box-content col-lg-6 col-md-12">
		<h3 class="dsvy-service-title"><a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3> 
		<div class="dsvy-service-cat"><h4><?php echo get_the_term_list( get_the_ID(), 'dsvy-service-category', '', ', ' ); ?></h4></div>
		<?php if( has_excerpt() ) : ?>
			<div class="dsvy-service-content"><?php the_excerpt(); ?></div>
		<?php endif; ?>
	</div>
	<div class="dsvy-service-img-wrapper col-lg-6 col-md-12" <?php if( !empty( $img_src[0] ) ) : ?> style="background-image:url('<?php echo esc_url( $img_src[0]); ?>');" <?php endif; ?>>
		<?php dsvy_get_featured_data( array( 'featured_img_only' => true, 'size' => 'dsvy-img-560x410' ) ); ?>
		<div class="dsvy-service-btn">
			<a class="btn-arrow" href="<?php the_permalink(); ?>"> <span class="dsvy-arrow"></span></a>
		</div>
	</div>
</div>