<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Karzo
 * @since 1.0
 * @version 1.0
 */
?>
<?php
$sidebar	= 'dsvy-sidebar-post';
$aria_label	= esc_attr__( 'Blog Sidebar', 'karzo' );
if( is_page() ){
	// page sidebar
	$sidebar	= 'dsvy-sidebar-page';
	$aria_label	= esc_attr__( 'Page Sidebar', 'karzo' );
	if( function_exists('is_woocommerce') && is_woocommerce() ){
		$sidebar	= 'dsvy-sidebar-wc-shop';
		$aria_label	= esc_attr__( 'WooCommerce Sidebar', 'karzo' );
	}
} else if( is_search() ){
	$sidebar	= 'dsvy-sidebar-search';
	$aria_label	= esc_attr__( 'Search Results Sidebar', 'karzo' );
} else if( function_exists('is_woocommerce') && is_woocommerce() && !is_product() ){
	$sidebar	= 'dsvy-sidebar-wc-shop';
	$aria_label	= esc_attr__( 'WooCommerce Sidebar', 'karzo' );
} else if( function_exists('is_product') && is_product() ){
	$sidebar	= 'dsvy-sidebar-wc-single';
	$aria_label	= esc_attr__( 'WooCommerce Sidebar', 'karzo' );
} else if( is_singular('event_listing') ){
	$sidebar		= 'dsvy-sidebar-event-single';
	$aria_label		= esc_attr__( 'Single Event Sidebar', 'karzo' );
} else if( is_tax('event_listing_category') || is_tax('event_listing_type') || is_singular( 'event_organizer' ) || is_singular( 'event_venue' ) ){
	$sidebar		= 'dsvy-sidebar-event';
	$aria_label		= esc_attr__( 'Event Sidebar', 'karzo' );
} else if( is_singular('dsvy-portfolio') ){
	$sidebar		= 'dsvy-sidebar-portfolio';
	$aria_label		= esc_attr__( 'Portfolio Sidebar', 'karzo' );
} else if( is_tax('dsvy-portfolio-category') || is_post_type_archive('dsvy-portfolio') ){
	$sidebar		= 'dsvy-sidebar-portfolio-cat';
	$aria_label		= esc_attr__( 'Portfolio Category Sidebar', 'karzo' );
} else if( is_singular('dsvy-service') ){
	$sidebar		= 'dsvy-sidebar-service';
	$aria_label		= esc_attr__( 'Service Sidebar', 'karzo' );
} else if( is_tax('dsvy-service-category') || is_post_type_archive('dsvy-service') ){
	$sidebar		= 'dsvy-sidebar-service-cat';
	$aria_label		= esc_attr__( 'Service Category Sidebar', 'karzo' );
} else if( is_singular('dsvy-team-member') ){
	$sidebar		= 'dsvy-sidebar-team';
	$aria_label		= esc_attr__( 'Team Member Sidebar', 'karzo' );
} else if( is_tax('dsvy-team-group') || is_post_type_archive('dsvy-team-member') ){
	$sidebar		= 'dsvy-sidebar-team-group';
	$aria_label		= esc_attr__( 'Team Group Sidebar', 'karzo' );
}

// check if content exists for the sidebar
$sidebar_content = '';
ob_start();
dynamic_sidebar( $sidebar );
$sidebar_content = ob_get_clean();

?>
<?php if ( is_active_sidebar( $sidebar ) && dsvy_check_sidebar()==true && !empty($sidebar_content) ) : ?>
<aside id="secondary" class="widget-area designervily-sidebar col-md-3 col-lg-3" aria-label="<?php echo esc_attr( $aria_label ); ?>">
	<?php dynamic_sidebar( $sidebar ); ?>
</aside><!-- #secondary -->
<?php endif; ?>