<?php
// Default titles
$portfolio_cpt_singular_title	= esc_attr__('Portfolio','karzo');
$portfolio_cat_singular_title	= esc_attr__('Portfolio Category','karzo');
$service_cpt_singular_title	= esc_attr__('Service','karzo');
$service_cat_singular_title	= esc_attr__('Service Category','karzo');
$team_cpt_singular_title	= esc_attr__('Team Member','karzo');
$team_group_singular_title	= esc_attr__('Team Group','karzo');
$testimonial_cpt_singular_title		= esc_attr__('Testimonial','karzo');
$testimonial_cat_singular_title	= esc_attr__('Testimonial Category','karzo');
if( class_exists('Kirki') ){
	// Portfolio
	$portfolio_cpt_singular_title2	= Kirki::get_option( 'portfolio-cpt-singular-title' );
	$portfolio_cpt_singular_title	= ( !empty($portfolio_cpt_singular_title2) ) ? $portfolio_cpt_singular_title2 : $portfolio_cpt_singular_title ;
	// Portfolio Category
	$portfolio_cat_singular_title2	= Kirki::get_option( 'portfolio-cat-singular-title' );
	$portfolio_cat_singular_title	= ( !empty($portfolio_cat_singular_title2) ) ? $portfolio_cat_singular_title2 : $portfolio_cat_singular_title ;
	// Service
	$service_cpt_singular_title2	= Kirki::get_option( 'service-cpt-singular-title' );
	$service_cpt_singular_title	= ( !empty($service_cpt_singular_title2) ) ? $service_cpt_singular_title2 : $service_cpt_singular_title ;
	// Service Category
	$service_cat_singular_title2	= Kirki::get_option( 'service-cat-singular-title' );
	$service_cat_singular_title	= ( !empty($service_cat_singular_title2) ) ? $service_cat_singular_title2 : $service_cat_singular_title ;
	// Team
	$team_cpt_singular_title2	= Kirki::get_option( 'team-cpt-singular-title' );
	$team_cpt_singular_title	= ( !empty($team_cpt_singular_title2) ) ? $team_cpt_singular_title2 : $team_cpt_singular_title ;
	// Team Group
	$team_group_singular_title2	= Kirki::get_option( 'team-group-singular-title' );
	$team_group_singular_title	= ( !empty($team_group_singular_title2) ) ? $team_group_singular_title2 : $team_group_singular_title ;
	// Testimonial
	$testimonial_cpt_singular_title2	= Kirki::get_option( 'testimonial-cpt-singular-title' );
	$testimonial_cpt_singular_title	= ( !empty($testimonial_cpt_singular_title2) ) ? $testimonial_cpt_singular_title2 : $testimonial_cpt_singular_title ;
	// Testimonial Category
	$testimonial_cat_singular_title2	= Kirki::get_option( 'testimonial-cat-singular-title' );
	$testimonial_cat_singular_title	= ( !empty($testimonial_cat_singular_title2) ) ? $testimonial_cat_singular_title2 : $testimonial_cat_singular_title ;
}
$pre_color_list = array(
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
	'secondarycolor'	=> get_template_directory_uri() . '/includes/images/precolor-secondarycolor.png',
	'transparent'		=> get_template_directory_uri() . '/includes/images/precolor-transparent.png',
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'light'				=> get_template_directory_uri() . '/includes/images/precolor-light.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'custom'			=> get_template_directory_uri() . '/includes/images/precolor-custom.png',
);
$pre_color_with_gradient_list = array(
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
	'secondarycolor'	=> get_template_directory_uri() . '/includes/images/precolor-secondarycolor.png',
	'gradientcolor'		=> get_template_directory_uri() . '/includes/images/precolor-gradientcolor.png',
	'transparent'		=> get_template_directory_uri() . '/includes/images/precolor-transparent.png',
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'light'				=> get_template_directory_uri() . '/includes/images/precolor-light.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'custom'			=> get_template_directory_uri() . '/includes/images/precolor-custom.png',
);
$pre_two_color_list = array(
	''					=> get_template_directory_uri() . '/includes/images/precolor-default.png',
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
);
$pre_text_color_list = array(
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
	'secondarycolor'	=> get_template_directory_uri() . '/includes/images/precolor-secondarycolor.png',
);
$pre_text_color_2_list = array(
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
);
$column_list = array(
	'1'	=> get_template_directory_uri() . '/includes/images/column-1.png',
	'2'	=> get_template_directory_uri() . '/includes/images/column-2.png',
	'3'	=> get_template_directory_uri() . '/includes/images/column-3.png',
	'4'	=> get_template_directory_uri() . '/includes/images/column-4.png',
	'5'	=> get_template_directory_uri() . '/includes/images/column-5.png',
	'6'	=> get_template_directory_uri() . '/includes/images/column-6.png',
);
// Total Header Styles
$header_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/header-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/header-style-2.jpg',
	'3'	=> get_template_directory_uri() . '/includes/images/header-style-3.jpg',
	'4'	=> get_template_directory_uri() . '/includes/images/header-style-4.jpg',
	'5'	=> get_template_directory_uri() . '/includes/images/header-style-5.jpg',
);
// Total Single Portfolio Styles
$portfolio_single_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/portfolio-single-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/portfolio-single-style-2.jpg',
);
// Total Single Service Styles
$service_single_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/service-single-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/service-single-style-2.jpg',
);
// Total Single Portfolio Styles
$team_single_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/team-single-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/team-single-style-2.jpg',
);
// Social links
$social_options_array = array();
if( function_exists('dsvy_social_links_list') ){
	$social_list = dsvy_social_links_list();
	foreach( $social_list as $social ){
		$social_options_array[] = array(
			'type'			=> 'text',
			'settings'		=> esc_attr( $social['id'] ),
			'label'			=> esc_attr( $social['label'] ),
			'description'	=> esc_attr__( 'Write Social URL.', 'karzo' ),
			'default'		=> '',
		);
	}
}
$footer_col_width_array = array(
	'hide'	=> esc_attr__( 'Hide this column', 'karzo' ),
	'1'		=> esc_attr__( '1%', 'karzo' ),
	'2'		=> esc_attr__( '2%', 'karzo' ),
	'3'		=> esc_attr__( '3%', 'karzo' ),
	'4'		=> esc_attr__( '4%', 'karzo' ),
	'5'		=> esc_attr__( '5%', 'karzo' ),
	'6'		=> esc_attr__( '6%', 'karzo' ),
	'7'		=> esc_attr__( '7%', 'karzo' ),
	'8'		=> esc_attr__( '8%', 'karzo' ),
	'9'		=> esc_attr__( '9%', 'karzo' ),
	'10'	=> esc_attr__( '10%', 'karzo' ),
	'11'	=> esc_attr__( '11%', 'karzo' ),
	'12'	=> esc_attr__( '12%', 'karzo' ),
	'13'	=> esc_attr__( '13%', 'karzo' ),
	'14'	=> esc_attr__( '14%', 'karzo' ),
	'15'	=> esc_attr__( '15%', 'karzo' ),
	'16'	=> esc_attr__( '16%', 'karzo' ),
	'17'	=> esc_attr__( '17%', 'karzo' ),
	'18'	=> esc_attr__( '18%', 'karzo' ),
	'19'	=> esc_attr__( '19%', 'karzo' ),
	'20'	=> esc_attr__( '20%', 'karzo' ),
	'21'	=> esc_attr__( '21%', 'karzo' ),
	'22'	=> esc_attr__( '22%', 'karzo' ),
	'23'	=> esc_attr__( '23%', 'karzo' ),
	'24'	=> esc_attr__( '24%', 'karzo' ),
	'25'	=> esc_attr__( '25%', 'karzo' ),
	'26'	=> esc_attr__( '26%', 'karzo' ),
	'27'	=> esc_attr__( '27%', 'karzo' ),
	'28'	=> esc_attr__( '28%', 'karzo' ),
	'29'	=> esc_attr__( '29%', 'karzo' ),
	'30'	=> esc_attr__( '30%', 'karzo' ),
	'31'	=> esc_attr__( '31%', 'karzo' ),
	'32'	=> esc_attr__( '32%', 'karzo' ),
	'33'	=> esc_attr__( '33%', 'karzo' ),
	'34'	=> esc_attr__( '34%', 'karzo' ),
	'35'	=> esc_attr__( '35%', 'karzo' ),
	'36'	=> esc_attr__( '36%', 'karzo' ),
	'37'	=> esc_attr__( '37%', 'karzo' ),
	'38'	=> esc_attr__( '38%', 'karzo' ),
	'39'	=> esc_attr__( '39%', 'karzo' ),
	'40'	=> esc_attr__( '40%', 'karzo' ),
	'41'	=> esc_attr__( '41%', 'karzo' ),
	'42'	=> esc_attr__( '42%', 'karzo' ),
	'43'	=> esc_attr__( '43%', 'karzo' ),
	'44'	=> esc_attr__( '44%', 'karzo' ),
	'45'	=> esc_attr__( '45%', 'karzo' ),
	'46'	=> esc_attr__( '46%', 'karzo' ),
	'47'	=> esc_attr__( '47%', 'karzo' ),
	'48'	=> esc_attr__( '48%', 'karzo' ),
	'49'	=> esc_attr__( '49%', 'karzo' ),
	'50'	=> esc_attr__( '50%', 'karzo' ),
	'51'	=> esc_attr__( '51%', 'karzo' ),
	'52'	=> esc_attr__( '52%', 'karzo' ),
	'53'	=> esc_attr__( '53%', 'karzo' ),
	'54'	=> esc_attr__( '54%', 'karzo' ),
	'55'	=> esc_attr__( '55%', 'karzo' ),
	'56'	=> esc_attr__( '56%', 'karzo' ),
	'57'	=> esc_attr__( '57%', 'karzo' ),
	'58'	=> esc_attr__( '58%', 'karzo' ),
	'59'	=> esc_attr__( '59%', 'karzo' ),
	'60'	=> esc_attr__( '60%', 'karzo' ),
	'61'	=> esc_attr__( '61%', 'karzo' ),
	'62'	=> esc_attr__( '62%', 'karzo' ),
	'63'	=> esc_attr__( '63%', 'karzo' ),
	'64'	=> esc_attr__( '64%', 'karzo' ),
	'65'	=> esc_attr__( '65%', 'karzo' ),
	'66'	=> esc_attr__( '66%', 'karzo' ),
	'67'	=> esc_attr__( '67%', 'karzo' ),
	'68'	=> esc_attr__( '68%', 'karzo' ),
	'69'	=> esc_attr__( '69%', 'karzo' ),
	'70'	=> esc_attr__( '70%', 'karzo' ),
	'71'	=> esc_attr__( '71%', 'karzo' ),
	'72'	=> esc_attr__( '72%', 'karzo' ),
	'73'	=> esc_attr__( '73%', 'karzo' ),
	'74'	=> esc_attr__( '74%', 'karzo' ),
	'75'	=> esc_attr__( '75%', 'karzo' ),
	'76'	=> esc_attr__( '76%', 'karzo' ),
	'77'	=> esc_attr__( '77%', 'karzo' ),
	'78'	=> esc_attr__( '78%', 'karzo' ),
	'79'	=> esc_attr__( '79%', 'karzo' ),
	'80'	=> esc_attr__( '80%', 'karzo' ),
	'81'	=> esc_attr__( '81%', 'karzo' ),
	'82'	=> esc_attr__( '82%', 'karzo' ),
	'83'	=> esc_attr__( '83%', 'karzo' ),
	'84'	=> esc_attr__( '84%', 'karzo' ),
	'85'	=> esc_attr__( '85%', 'karzo' ),
	'86'	=> esc_attr__( '86%', 'karzo' ),
	'87'	=> esc_attr__( '87%', 'karzo' ),
	'88'	=> esc_attr__( '88%', 'karzo' ),
	'89'	=> esc_attr__( '89%', 'karzo' ),
	'90'	=> esc_attr__( '90%', 'karzo' ),
	'91'	=> esc_attr__( '91%', 'karzo' ),
	'92'	=> esc_attr__( '92%', 'karzo' ),
	'93'	=> esc_attr__( '93%', 'karzo' ),
	'94'	=> esc_attr__( '94%', 'karzo' ),
	'95'	=> esc_attr__( '95%', 'karzo' ),
	'96'	=> esc_attr__( '96%', 'karzo' ),
	'97'	=> esc_attr__( '97%', 'karzo' ),
	'98'	=> esc_attr__( '98%', 'karzo' ),
	'99'	=> esc_attr__( '99%', 'karzo' ),
	'100'	=> esc_attr__( '100%', 'karzo' ),
);

$blog_styles = dsvy_element_template_list('blog', 'customizer');
unset($blog_styles['classic'], $blog_styles['3']);

/*** Options array ***/
$kirki_options_array = array(
	// General Settings
	'general_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'General Options', 'karzo' ),
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'color',
				'settings'		=> 'global-color',
				'label'			=> esc_attr__( 'Global Color', 'karzo' ),
				'description'	=> esc_attr__( 'This color will be globally applied to most of elements parts and special texts', 'karzo' ),
				'default'		=> '#32b0ff',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'secondary-color',
				'label'			=> esc_attr__( 'Secondary Color', 'karzo' ),
				'description'	=> esc_attr__( 'This color will be used on some elements. Sometimes with Global Color. This should match with Global Color to look good.', 'karzo' ),
				'default'		=> '#05155e',
			),
			array(
				'type'		=> 'multicolor',
				'settings'	=> 'gradient-color',
				'label'		=> esc_attr__( 'Gradient Color', 'karzo' ),
				'choices'		=> array(
					'first'		=> esc_attr__( 'Starting Color', 'karzo' ),
					'last'		=> esc_attr__( 'Ending Color', 'karzo' ),
				),
				'default'	=> array(
				  'first'		=> '#32b0ff',
				  'last'		=> '#32b0ff',
				),
			),
			array(
				'type'				=> 'image',
				'settings'			=> 'logo',
				'label'				=> esc_attr__( 'Logo', 'karzo' ),
				'description'		=> esc_attr__( 'Main logo', 'karzo' ),
				'default'			=> get_template_directory_uri() . '/images/logo.svg',
				'partial_refresh'	=> array(
					'logo'				=> array(
						'selector'			=> '.site-title',
						'render_callback'	=> function() {
							return dsvy_logo( 'yes' );
						},
					)
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'logo-height',
				'label'			=> esc_attr__( 'Logo Max Height', 'karzo' ),
				'default'		=> 60,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
			),
			array(
				'type'			=> 'image',
				'settings'		=> 'sticky-logo',
				'label'			=> esc_attr__( 'Sticky Logo', 'karzo' ),
				'description'	=> esc_attr__( 'Sticky logo', 'karzo' ),
				'default'		=> '',
				'active_callback'=> array( array(
					'setting' => 'sticky-header',
					'operator' => '==',
					'value' => '1',
				) ),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'sticky-logo-height',
				'label'			=> esc_attr__( 'Sticky Logo Max Height', 'karzo' ),
				'default'		=> 60,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
				'active_callback'=> array( array(
					'setting' => 'sticky-header',
					'operator' => '==',
					'value' => '1',
				) ),
			),
			array(
				'type'			=> 'image',
				'settings'		=> 'responsive-logo',
				'label'			=> esc_attr__( 'Responsive Logo', 'karzo' ),
				'description'	=> esc_attr__( 'This logo appear in small devices like mobile/tablet etc', 'karzo' ),
				'default'		=> '',
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'responsive-logo-height',
				'label'			=> esc_attr__( 'Responsive Logo Max Height', 'karzo' ),
				'default'		=> 50,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
			),
			array(
				'type'		=> 'multicolor',
				'settings'	=> 'link-color',
				'label'		=> esc_attr__( 'Link Color', 'karzo' ),
				'choices'		=> array(
					'normal'	=> esc_attr__( 'Normal Color', 'karzo' ),
					'hover'		=> esc_attr__( 'Mouse-Over (Hover) Color', 'karzo' ),
				),
				'default'	=> array(
					'normal'	=> '#05155e',
					'hover'		=> '#32b0ff',
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'preloader',
				'label'			=> esc_attr__( 'Show Preloader?', 'karzo' ),
				'description'	=> esc_attr__( 'Show or hide preloader', 'karzo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'preloader-image',
				'label'			=> esc_html__( 'Select preloader image', 'karzo' ),
				'default'		=> '1',
				'choices'		=> array(
					'1'   => get_template_directory_uri() . '/images/loader1.svg',
					'2'   => get_template_directory_uri() . '/images/loader2.svg',
					'3'   => get_template_directory_uri() . '/images/loader3.svg',
					'4'   => get_template_directory_uri() . '/images/loader4.svg',
					'5'   => get_template_directory_uri() . '/images/loader5.svg',
					'6'   => get_template_directory_uri() . '/images/loader6.svg',
					'7'   => get_template_directory_uri() . '/images/loader7.svg',
					'8'   => get_template_directory_uri() . '/images/loader8.svg',
					'9'   => get_template_directory_uri() . '/images/loader9.svg',
				),
				'active_callback'=> array( array(
					'setting' => 'preloader',
					'operator' => '==',
					'value' => '1',
				) ),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'responsive-breakpoint',
				'label'			=> esc_attr__( 'Responsive Breakpoint', 'karzo' ),
				'description'	=> esc_attr__( 'Select screen size to make the menu burger menu (responsive menu) below the selected screen size and also other settings too. Preferred Sizes: 1200, 1024, 992 and 768', 'karzo' ),
				'default'		=> 1200,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 2000,
					'step'			=> 1,
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-page',
				'label'		=> esc_html__( 'Page Sidebar', 'karzo' ),
				'default'	=> 'right',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Advanced Settings
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-advanced-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Advanced Settings', 'karzo' ) . '</h2> <span>' . esc_html__( 'Special advanced options', 'karzo' ) . '</span></div>',
			),
			array(
				'type'        => 'switch',
				'settings'    => 'min',
				'label'       => esc_attr__( 'Load Minified CSS and JS Files?', 'karzo' ),
				'description' => esc_attr__( 'Load minified files for CSS and JS code files. Select YES to reduce page load time.', 'karzo' ),
				'default'     => '1',
				'choices'     => array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'white-color',
				'label'			=> esc_attr__( 'White Color', 'karzo' ),
				'description'	=> esc_attr__( 'This is default white color for text.', 'karzo' ),
				'default'		=> '#ffffff',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'light-bg-color',
				'label'			=> esc_attr__( 'Light Background Color', 'karzo' ),
				'description'	=> esc_attr__( 'This is default grey background color.', 'karzo' ),
				'default'		=> '#f0f2f7',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'blackish-color',
				'label'			=> esc_attr__( 'Blackish Text Color', 'karzo' ),
				'description'	=> esc_attr__( 'This is default blackish color for text.', 'karzo' ),
				'default'		=> '#101010',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'blackish-bg-color',
				'label'			=> esc_attr__( 'Blackish Background Color', 'karzo' ),
				'description'	=> esc_attr__( 'This is default blackish background color.', 'karzo' ),
				'default'		=> '#101010',
			),
		)
	),
	// Typography Settings
	'typography_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Typography Options', 'karzo' ),
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'typography',
				'settings'		=> 'global-typography',
				'label'			=> esc_attr__( 'Global Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array (
					'font-family'		=> 'Rubik',
					'variant'			=> 'regular',
					'font-size'			=> '16px',
					'line-height'		=> '1.6',
					'letter-spacing'	=> '0px',
					'color'				=> '#666666',
					'text-transform'	=> 'none',
					'font-backup'		=> '',					
					'font-style'		=> 'normal',
				  ),
				'priority'			=> 10,
				'dsvy-output'		=> 'body',
				'dsvy-all-variants'	=> true,
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h1-typography',
				'label'			=> esc_attr__( 'H1 Typography', 'karzo' ),
				'tooltip'     => esc_attr__( 'This is tooltip', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '500',
					'font-size'			=> '38px',
					'line-height'		=> '42px',
					'letter-spacing'	=> '0px',
					'color'				=> '#05155e',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> 'h1',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h2-typography',
				'label'			=> esc_attr__( 'H2 Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '500',
					'font-size'			=> '34px',
					'line-height'		=> '38px',
					'letter-spacing'	=> '0px',
					'color'				=> '#05155e',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> 'h2',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h3-typography',
				'label'			=> esc_attr__( 'H3 Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '500',
					'font-size'			=> '30px',
					'line-height'		=> '34px',
					'letter-spacing'	=> '0px',
					'color'				=> '#05155e',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> 'h3',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h4-typography',
				'label'			=> esc_attr__( 'H4 Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '500',
					'font-size'			=> '26px',
					'line-height'		=> '30px',
					'letter-spacing'	=> '0px',
					'color'				=> '#05155e',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> 'h4',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h5-typography',
				'label'			=> esc_attr__( 'H5 Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '500',
					'font-size'			=> '22px',
					'line-height'		=> '26px',
					'letter-spacing'	=> '0px',
					'color'				=> '#05155e',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> 'h5',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h6-typography',
				'label'			=> esc_attr__( 'H6 Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '500',
					'font-size'			=> '18px',
					'line-height'		=> '22px',
					'letter-spacing'	=> '0px',
					'color'				=> '#05155e',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> 'h6',
			),
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Special Heading Typography', 'karzo' ) . '</h2> <span>' . esc_html__( 'Heading typography options', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'heading-typography',
				'label'			=> esc_attr__( 'Heading Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '500',
					'font-size'			=> '48px',
					'line-height'		=> '48px',
					'letter-spacing'	=> '0px',
					'color'				=> '#05155e',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.dsvy-heading-subheading .dsvy-element-title',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'subheading-typography',
				'label'			=> esc_attr__( 'Sub-heading Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '400',
					'font-size'			=> '14px',
					'line-height'		=> '20px',
					'letter-spacing'	=> '1px',
					'color'				=> '#32b0ff',
					'text-transform'	=> 'uppercase',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.dsvy-heading-subheading .dsvy-element-subtitle',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'content-typography',
				'label'			=> esc_attr__( 'Content Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '400',
					'font-size'			=> '16px',
					'line-height'		=> '28px',
					'letter-spacing'	=> '0px',
					'color'				=> '#666666',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.dsvy-ihbox.dsvy-ihbox-style-hsbox .dsvy-ihbox-content',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'widget-heading-typography',
				'label'			=> esc_attr__( 'Widget Heading Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '500',
					'font-size'			=> '22px',
					'line-height'		=> '32px',
					'letter-spacing'	=> '0px',
					'color'				=> '#101010',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '			
				.designervily-sidebar .widget_search .wp-block-search__label, .designervily-sidebar .widget_block .wp-block-group h2, 
				.widget-title, .dsvy-footer-copyright-box h3',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'buttons-typography',
				'label'			=> esc_attr__( 'Button Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '500italic',
					'font-size'			=> '13px',
					'line-height'		=> '23px',
					'letter-spacing'	=> '0px',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'dsvy-output'	=> '.dsvy-search-results-back-global-btn a, .dsvy-search-results-load-btn a, .wpem-theme-button, a.wpem-theme-button, button.wpem-theme-button, input.wpem-theme-button, .dsvy-read-more-link a, .dsvy-service-btn a, .dsvy-header-button a, .dsvy-header-button2 a, .woocommerce ul.products li.product .onsale, .woocommerce div.product .woocommerce-tabs ul.tabs li a, .elementor-widget-button .elementor-button, .dsvy-ptable-btn a, .dsvy-service-btn, .dsvy-ihbox-btn, .woocommerce .woocommerce-message .button, .woocommerce div.product form.cart .button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, button, html input[type=button], input[type=reset], input[type=submit]',
			),
			// Extra Load Fonts Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'css-only-custom-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'CSS only Typography', 'karzo' ) . '</h2> <span>' . esc_html__( 'This will not apply to any font style but this font will be loaded so we can use anywhere.', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'css-only-1-typography',
				'label'			=> esc_attr__( 'First Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '400',
					'font-style'		=> 'normal',
					'font-backup'		=> '',
				),
				'dsvy-output'	=> 'blockquote, .dsvy-ourhistory .label, .site-header .dsvy-slider-area .hermes .tp-bullet:after,.dsvy-pricing-table-box .designervily-ptable-price-w, .dsvy-service-style-1 .designervily-box-content:after,  #dsvy-count-down .content_countdown .time_left,.dsvy-ihbox-style-1 .dsvy-ihbox-icon .dsvy-ihbox-icon-wrapper, .dsvy-estimate-form #lfb_bootstraped.lfb_bootstraped .lfb_richtext h3, .dsvy-estimate-form #lfb_bootstraped.lfb_bootstraped .lfb_richtext h2',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'css-only-2-typography',
				'label'			=> esc_attr__( 'Second Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '500',
					'font-style'		=> 'normal',
					'font-backup'		=> '',
				),
				'dsvy-output'	=> '.dsvy-comment-date a,.comment-respond input[type="text"], .comment-respond input[type="email"], .comment-respond textarea,.comment-respond input[type="url"],.dsvy-ihbox-style-4:before,.post-navigation .nav-links .nav-title, .post-navigation .nav-links .nav-title',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'css-only-3-typography',
				'label'			=> esc_attr__( 'Third Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '600',
					'font-style'		=> 'normal',
					'font-backup'		=> '',
				),
				'dsvy-output'	=> '#dsvy-count-down .countdown .time_description, .dsvy-service-style-3 .dsvy-service-cat h4 a,.dsvy-testimonial-style-3 .designervily-box-desc blockquote',
			),
		)
	),
	// Pre-Header Options
	'preheader_options'	=> array(
		'section_settings'	=> array(
			'title'				=> esc_attr__( 'Pre-Header Options', 'karzo' ),
			'panel'				=> 'karzo_base_options',
			'priority'			=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'switch',
				'settings'		=> 'preheader-enable',
				'label'			=> esc_attr__( 'Show or hide Pre-header', 'karzo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'			=> esc_attr__( 'Show', 'karzo' ),
					'off'			=> esc_attr__( 'Hide', 'karzo' ),
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'preheader-text-color',
				'label'				=> esc_attr__( 'Select pre-header text color', 'karzo' ),
				'default'			=> 'white',
				'choices'			=> $pre_text_color_list,
				'active_callback'	=> array(
					array(
						'setting'		=> 'preheader-enable',
						'operator'		=> '==',
						'value'			=> '1',
					)
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'preheader-bgcolor',
				'label'				=> esc_html__( 'Select pre-header background color', 'karzo' ),
				'default'			=> 'transparent',
				'choices'			=> $pre_color_list,
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'preheader-bgcolor-custom',
				'label'			=> esc_attr__( 'Select pre-header background custom color', 'karzo' ),
				'description'	=> esc_attr__( 'Select custom color for pre-header background', 'karzo' ),
				'default'		=> '#ff5e15',
				'active_callback'=> array(
					array(
						'setting'	=> 'preheader-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					),
					array(
						'setting'			=> 'preheader-enable',
						'operator'			=> '==',
						'value'				=> '1',
					)
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'preheader-responsive',
				'label'			=> esc_attr__( 'Hide in screen size', 'karzo' ),
				'description'	=> esc_attr__( 'Select screen size to hide this pre-header below the selected screen size. Preferred Sizes: 1200, 1024, 992 and 768', 'karzo' ),
				'default'		=> 1200,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 2000,
					'step'			=> 1,
				),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'preheader-content-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Preheader content', 'karzo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Manage preheader content from here', 'karzo' ) , $portfolio_cpt_singular_title ) . '</span></div>',
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'preheader-left',
				'label'			=> esc_attr__( 'Pre-header Left Content', 'karzo' ),
				'default'		=> dsvy_esc_kses('<i class="dsvy-base-icon-marker"></i> Los Angeles Gournadi, 1230  Bariasl'),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
				'partial_refresh'	=> array(
					'preheader-left'		=> array(
						'selector'			=> '.dsvy-pre-header-left',
						'render_callback'	=> function() {
							return get_theme_mod('preheader-left');
						},
					)
				),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'preheader-right',
				'label'			=> esc_attr__( 'Pre-header Right Content', 'karzo' ),
				'default'		=> dsvy_esc_kses('<ul class="dsvy-contact-info"><li><i class="dsvy-base-icon-contact"></i> Make a call  : +1 (212) 255-5511</li><li>[dsvy-social-links]</li></ul>'),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
				'partial_refresh'	=> array(
					'preheader-right'		=> array(
						'selector'			=> '.dsvy-pre-header-right',
						'render_callback'	=> function() {
							return get_theme_mod('preheader-right');
						},
					)
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'preheader-search',
				'label'			=> esc_attr__( 'Show Search Icon in Pre-header Right Area?', 'karzo' ),
				'description'	=> esc_attr__( 'Select YES to show search icon in pre-header right side.', 'karzo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
		),
	),
	// Header Options
	'header_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Header Options', 'karzo' ),
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'header-style',
				'label'		=> esc_html__( 'Header Style', 'karzo' ),
				'description'	=> '<div class="dsvy-alert-message">'.esc_html__( 'NOTE: This will also change other options (like background color, menu color, logo etc) to set it with this header.', 'karzo' ).'</div>',
				'default'	=> '1',
				'choices'		=> $header_style_array,
			),

			// Header button
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-button-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Header Button', 'karzo' ) . '</h2> <span>' . esc_html__( 'Set header button title and link', 'karzo' ) . '</span></div>',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
					)
				),
			),

			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn-text',
				'label'				=> esc_attr__( 'Header Button Text (1st line)', 'karzo' ),
				'default'		=> esc_attr__( 'Have any Question ?', 'karzo' ),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
					)
				),
				'partial_refresh'	=> array(
					'header-btn-text'	=> array(
						'selector'			=> '.dsvy-header-button',
						'render_callback'	=> function() {
							return dsvy_header_button( array('inneronly'=>'yes') );
						},
					)
				),
			),

			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn-text2',
				'label'				=> esc_attr__( 'Header Button Text (2nd line)', 'karzo' ),
				'default'		=> esc_attr__( 'Have any Question ?', 'karzo' ),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
					)
				),
				'partial_refresh'	=> array(
					'header-btn-text2'	=> array(
						'selector'			=> '.dsvy-header-button',
						'render_callback'	=> function() {
							return dsvy_header_button( array('inneronly'=>'yes') );
						},
					)
				),
			),

			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn-url',
				'label'				=> esc_attr__( 'Header Button Link (URL)', 'karzo' ),
				'default'			=> '',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),	
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
					)
				),
			),

			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-button2-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Header Button Second', 'karzo' ) . '</h2> <span>' . esc_html__( 'Set header button title and link', 'karzo' ) . '</span></div>',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),	
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),
					)
				),
			),

			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn2-text',
				'label'				=> esc_attr__( 'Header Button Text', 'karzo' ),
				'default'		=> esc_attr__( 'Have any Question ?', 'karzo' ),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),

					)
				),
				'partial_refresh'	=> array(
					'header-btn2-text'	=> array(
						'selector'			=> '.dsvy-header-button2',
						'render_callback'	=> function() {
							return dsvy_header_button_second( array('inneronly'=>'yes') );
						},
					)
				),
			),
			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn2-url',
				'label'				=> esc_attr__( 'Header Button Link (URL)', 'karzo' ),
				'default'			=> '',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '5',
						),

					)
				),
			),

			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'General Options', 'karzo' ) . '</h2> <span>' . esc_html__( 'Common options that apply to all header styles', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'header-height',
				'label'			=> esc_attr__( 'Header Height (in pixel)', 'karzo' ),
				'description'	=> esc_attr__( 'Select header height', 'karzo' ),
				'default'		=> 95,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 900,
					'step'			=> 1,
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'header-bgcolor',
				'label'				=> esc_html__( 'Select header background color', 'karzo' ),
				'default'			=> 'transparent',
				'choices'			=> $pre_color_list,
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'header-background-color',
				'label'			=> esc_attr__( 'Header Background Color', 'karzo' ),
				'description'	=> esc_attr__( 'Select custom color for header background', 'karzo' ),
				'default'		=> '#ffffff',
				'active_callback'=> array(
					array(
						'setting'	=> 'header-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					)
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'menu-bgcolor',
				'label'				=> esc_html__( 'Select menu area background color', 'karzo' ),
				'default'			=> 'white',
				'choices'			=> $pre_color_list,
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '6',
						),
					)
				),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'menu-background-color',
				'label'			=> esc_attr__( 'Menu Area Background Color', 'karzo' ),
				'description'	=> esc_attr__( 'Select custom color for Menu area background', 'karzo' ),
				'default'		=> '#ffffff',
				'active_callback'=> array(
					array(
						'setting'	=> 'menu-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					)
				),
			),
			// Search in Header
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-search-header-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Search in Header', 'karzo' ) . '</h2> <span>' . esc_html__( 'Options for search in header area', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'header-search',
				'label'			=> esc_attr__( 'Show Search Icon in Header Area?', 'karzo' ),
				'description'	=> esc_attr__( 'Select YES to show search icon in header area.', 'karzo' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
			),

			// Sticky Header
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-sticky-header-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Sticky Header Options', 'karzo' ) . '</h2> <span>' . esc_html__( 'Options for sticky header area', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'sticky-header',
				'label'			=> esc_attr__( 'Sticky Header on Scroll?', 'karzo' ),
				'description'	=> esc_attr__( 'Select YES to make header sticky on scroll.', 'karzo' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'sticky-header-height',
				'label'			=> esc_attr__( 'Sticky Area Height (in pixel)', 'karzo' ),
				'description'	=> esc_attr__( 'Select Area height for sticky header', 'karzo' ),
				'default'		=> 90,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 300,
					'step'			=> 1,
				),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'sticky-header',
							'operator'	=> '==',
							'value'		=> '1',
						),
					)
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'sticky-header-bgcolor',
				'label'				=> esc_html__( 'Sticky Area Background Color', 'karzo' ),
				'default'			=> 'white',
				'choices'			=> $pre_color_list,
				'active_callback'	=> array(
					array(
						'setting'	=> 'sticky-header',
						'operator'	=> '==',
						'value'		=> '1',
					)
				),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'sticky-header-background-color',
				'label'			=> esc_attr__( 'Sticky Header Background Custom Color', 'karzo' ),
				'description'	=> esc_attr__( 'Select custom color for sticky header background', 'karzo' ),
				'default'		=> '#ffffff',
				'active_callback'=> array(
					array(
						'setting'	=> 'sticky-header',
						'operator'	=> '==',
						'value'		=> '1',
					),
					array(
						'setting'	=> 'sticky-header-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					)
				),
			),
			// Responsive Header
			array(
				'type'			=> 'custom',
				'settings'		=> 'responsive-header-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Responsive Header Options', 'karzo' ) . '</h2> <span>' . esc_html__( 'Options for responsive (mobile or tablet mode) header area', 'karzo' ) . '</span></div>',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'responsive-header-bgcolor',
				'label'				=> esc_html__( 'Select header background color', 'karzo' ),
				'default'			=> 'white',
				'choices'			=> $pre_two_color_list,
			),
		),
	),
	// Menu Options
	'menu_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Menu Options', 'karzo' ),
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Main Menu Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'main-menu-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Main Menu Options', 'karzo' ) . '</h2> <span>' . esc_html__( 'Set Main Menu font settings', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'main-menu-typography',
				'label'			=> esc_attr__( 'Main Menu Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '500',
					'font-size'			=> '14px',
					'line-height'		=> '20px',
					'letter-spacing'	=> '0px',
					'color'				=> '#05155e',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> 'body:not(.mega-menu-designervily-top) .dsvy-navbar div > ul > li > a, .dsvy-max-mega-menu-override #page #site-navigation .max-mega-menu > li.mega-menu-item > a.mega-menu-link',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'main-menu-active-color',
				'label'			=> esc_attr__( 'Main Menu Active Link Color', 'karzo' ),
				'description'	=> esc_attr__( 'This color will be applied to main menu when the menu link is active', 'karzo' ),
				'default'		=> 'globalcolor',
				'choices'		=> $pre_text_color_list,
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'main-menu-sticky-color',
				'label'			=> esc_attr__( 'Main Menu Text Color for Sticky Header', 'karzo' ),
				'description'	=> esc_attr__( 'This color will be applied to main menu text when header is sticky', 'karzo' ),
				'default'		=> '#05155e',
			),
			// Dropdown Menu Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'drop-down-menu-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Dropdown Menu Options', 'karzo' ) . '</h2> <span>' . esc_html__( 'Set Dropdown font settings', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'dropdown-menu-typography',
				'label'			=> esc_attr__( 'Dropdown Menu Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '500',
					'font-size'			=> '13px',
					'line-height'		=> '20px',
					'letter-spacing'	=> '0px',
					'color'				=> '#05155e',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.dsvy-navbar ul ul a, 

				.dsvy-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-flyout > ul.mega-sub-menu li.mega-menu-item a.mega-menu-link,
				.dsvy-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li > ul.mega-sub-menu li.mega-menu-item > a:hover, 
				.dsvy-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li > ul.mega-sub-menu li.mega-menu-item > a:focus,
				.dsvy-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-megamenu > ul.mega-sub-menu ul:not(.menu) > li.mega-menu-item > a.mega-menu-link,
				.dsvy-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-megamenu > ul.mega-sub-menu li .widget_nav_menu ul.menu > li.mega-menu-item > a.mega-menu-link',
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'dropdown_background',
				'label'			=> esc_attr__( 'Dropdown Menu Background', 'karzo' ),
				'description'	=> esc_attr__( 'Background settings for Dropdown Menu', 'karzo' ),
				'default'		=> array(
					'background-color'		=> '#ffffff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'dsvy-output'	=> '.dsvy-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-flyout > ul.mega-sub-menu, 
									.dsvy-navbar ul ul, .dsvy-navbar ul ul:before',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'drop-down-menu-active-color',
				'label'				=> esc_html__( 'Dropdown Menu Active Color', 'karzo' ),
				'default'			=> 'globalcolor',
				'choices'			=> $pre_text_color_list,
			),
			// Max Mega Menu Option
			array(
				'type'			=> 'custom',
				'settings'		=> 'max-mega-menu-override-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Max Mega Menu Plugin Option', 'karzo' ) . '</h2> <span>' . esc_html__( 'Option for Max Mega Menu plugin', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'max-mega-menu-override',
				'label'			=> esc_attr__( 'Override Max Mega Menu design?', 'karzo' ),
				'description'	=> esc_attr__( 'Select YES to override Max Mega Menu design. Make sure you are using "Max Mega Menu" plugin for mega menu', 'karzo' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'mmm-title-typography',
				'label'			=> esc_attr__( 'Max Mega Menu - Widget Title Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '500',
					'font-size'			=> '16px',
					'line-height'		=> '20px',
					'letter-spacing'	=> '0px',
					'color'				=> '#232e35',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.dsvy-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title, .dsvy-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title',
			),

			array( // 1st dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-1-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 1st Dropdown Menu Background Option', 'karzo' ),
				'description'	=> esc_attr__( 'Background settings for first Dropdown Menu in Max Mega Menu', 'karzo' ),
				'default'		=> array(
					'background-color'		=> '#ffffff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'dsvy-output'	=> '.dsvy-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(1) > ul.mega-sub-menu',
			),
			array( // 2nd dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-2-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 2nd Dropdown Menu Background Option', 'karzo' ),
				'description'	=> esc_attr__( 'Background settings for second Dropdown Menu in Max Mega Menu', 'karzo' ),
				'default'		=> array(
					'background-color'		=> '#ffffff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'dsvy-output'	=> '.dsvy-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(2) > ul.mega-sub-menu',
			),
			array( // 3rd dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-3-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 3rd Dropdown Menu Background Option', 'karzo' ),
				'description'	=> esc_attr__( 'Background settings for third Dropdown Menu in Max Mega Menu', 'karzo' ),
				'default'		=> array(
					'background-color'		=> '#ffffff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'dsvy-output'	=> '.dsvy-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(3) > ul.mega-sub-menu',
			),
			array( // 4th dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-4-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 4th Dropdown Menu Background Option', 'karzo' ),
				'description'	=> esc_attr__( 'Background settings for fourth Dropdown Menu in Max Mega Menu', 'karzo' ),
				'default'		=> array(
					'background-color'		=> '#ffffff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'dsvy-output'	=> '.dsvy-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(4) > ul.mega-sub-menu',
			),
			array( // 5th dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-5-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 5th Dropdown Menu Background Option', 'karzo' ),
				'description'	=> esc_attr__( 'Background settings for fifth Dropdown Menu in Max Mega Menu', 'karzo' ),
				'default'		=> array(
					'background-color'		=> '#ffffff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'dsvy-output'	=> '.dsvy-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(5) > ul.mega-sub-menu',
			),
			array( // 6th dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-6-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 6th Dropdown Menu Background Option', 'karzo' ),
				'description'	=> esc_attr__( 'Background settings for sixth Dropdown Menu in Max Mega Menu', 'karzo' ),
				'default'		=> array(
					'background-color'		=> '#ffffff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'dsvy-output'	=> '.dsvy-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(6) > ul.mega-sub-menu',
			),

		)
	),
	// Titlebar Options
	'titlebar_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Titlebar Options', 'karzo' ),
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'switch',
				'settings'		=> 'titlebar-enable',
				'label'			=> esc_attr__( 'Show Titlebar?', 'karzo' ),
				'description'	=> esc_attr__( 'Show or hide Titlebar', 'karzo' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'titlebar-height',
				'label'			=> esc_attr__( 'Titlebar Height', 'karzo' ),
				'default'		=> 340,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'titlebar-style',
				'label'			=> esc_attr__( 'Titlebar Style', 'karzo' ),
				'description'	=> esc_attr__( 'Select style for Titlebar', 'karzo' ),
				'default'		=> 'center',
				'choices'		=>  array(
					'left'			=> esc_attr__( 'All Left Aligned', 'karzo' ),
					'center'		=> esc_attr__( 'All Center Aligned', 'karzo' )
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'titlebar-hide-breadcrumb',
				'label'			=> esc_attr__( 'Hide Breadcrumb?', 'karzo' ),
				'description'	=> esc_attr__( 'Show or hide breadcrumb in Titlebar', 'karzo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'multicheck',
				'settings'		=> 'titlebar-bg-featured',
				'label'			=> esc_attr__( 'Featured Image as Titlebar Background', 'karzo' ),
				'description'	=> esc_attr__( 'Select which section (CPT) will show featured image as background image in Titlebar. NOTE: This will work for Single view only.', 'karzo' ),
				'default'		=> array(),
				'choices'		=> array(
					'post'				=> sprintf( esc_attr__('For %1$s', 'karzo') , '"Post"' ),
					'page'				=> sprintf( esc_attr__('For %1$s', 'karzo') , '"Page"' ),
					'dsvy-portfolio'	=> sprintf( esc_attr__('For %1$s', 'karzo') , '"'.$portfolio_cpt_singular_title.'"' ),
					'dsvy-team-member'	=> sprintf( esc_attr__('For %1$s', 'karzo') , '"'.$team_cpt_singular_title.'"' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'titlebar-bgcolor',
				'label'				=> esc_html__( 'Select Titlebar background color', 'karzo' ),
				'default'			=> 'secondarycolor',
				'choices'			=> $pre_color_with_gradient_list,
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'titlebar-background',
				'label'			=> esc_attr__( 'Background', 'karzo' ),
				'description'	=> esc_attr__( 'Background Settings', 'karzo' ),
				'default'		=> array(
					'background-color'      => '#f6f6f6',
					'background-repeat'     => 'no-repeat',
					'background-position'   => 'center center',
					'background-size'       => 'cover',
					'background-attachment' => 'scroll',
				),
				'dsvy-output'	=> '.dsvy-title-bar-wrapper, .dsvy-title-bar-wrapper.dsvy-bg-color-custom:before',
				'active_callback' => array( array(
					'setting'		=> 'titlebar-enable',
					'operator'		=> '==',
					'value'			=> '1',
				) ),
			),
			array(
				'type'		=> 'typography',
				'settings'	=> 'titlebar-heading-typography',
				'label'		=> esc_attr__( 'Titlebar Heading Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '400',
					'font-size'			=> '60px',
					'line-height'		=> '70px',
					'letter-spacing'	=> '0px',
					'color'				=> '#ffffff',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.dsvy-tbar-title',
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'titlebar-subheading-typography',
				'label'			=> esc_attr__( 'Titlebar Sub-heading Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '400',
					'font-size'			=> '14px',
					'line-height'		=> '0',
					'letter-spacing'	=> '0px',
					'color'				=> '#ffffff',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'dsvy-output'	=> '.dsvy-tbar-subtitle',
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'titlebar-breadcrumb-typography',
				'label'			=> esc_attr__( 'Titlebar Breadcrumb Typography', 'karzo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Rubik',
					'variant'			=> '400',
					'font-size'			=> '14px',
					'line-height'		=> '0',
					'letter-spacing'	=> '0px',
					'color'				=> '#ffffff',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
			'priority'				=> 10,
				'dsvy-output'		=> '.dsvy-breadcrumb, .dsvy-breadcrumb a',
				'active_callback'	=> array(
					array(
						'setting'			=> 'titlebar-enable',
						'operator'			=> '==',
						'value'				=> '1',
					),
					array(
						'setting'			=> 'titlebar-hide-breadcrumb',
						'operator'			=> '==',
						'value'				=> '0',
					)
				),
			),
		),
	),
	// Footer Options
		'footer_options' => array(
			'section_settings' => array(
				'title'			=> esc_attr__( 'Footer Options', 'karzo' ),
				'panel'			=> 'karzo_base_options',
				'priority'		=> 160,
			),
			'section_fields' => array(

			// Footer Background settings
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-background-settings-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Footer Background Settings', 'karzo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Manage footer background settings from here', 'karzo' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'footer-style',
				'label'			=> esc_html__( 'Select Footer Style', 'karzo' ),
				'default'		=> '1',
				'choices'		=> array(
					'1'				=> get_template_directory_uri() . '/includes/images/footer-style-1.jpg',
					'2'				=> get_template_directory_uri() . '/includes/images/footer-style-2.jpg',
				)
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'footer-bgcolor',
				'label'			=> esc_html__( 'Select Full Footer background color', 'karzo' ),
				'description'	=> esc_attr__( 'This will be applied to full footer area including footer widget area and footer copyright area.', 'karzo' ),
				'default'		=> 'secondary',
				'choices'		=> array_merge( array('gradientcolor'	=> get_template_directory_uri() . '/includes/images/precolor-gradientcolor.png',), $pre_color_list),
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'footer-background',
				'label'			=> esc_attr__( 'Full Footer Background', 'karzo' ),
				'description'	=> esc_attr__( 'This will be applied to full footer area including footer widget area and footer copyright area.', 'karzo' ),
				'default'		=> array(
					'background-color'		=> '#05155e',
					'background-image'		=> '',
					'background-repeat'		=> 'no-repeat',
					'background-position'	=> 'center top',
					'background-size'		=> 'contain',
					'background-attachment'	=> 'scroll',
				),
				'dsvy-output'	=> '.site-footer, .site-footer.dsvy-bg-color-custom:before',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-text-color',
				'label'				=> esc_attr__( 'Select Footer Text Color', 'karzo' ),
				'default'			=> 'white',
				'choices'			=> $pre_text_color_list,
			),

			// Footer Boxes Area
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-boxes-area-heading',
				'default'		=> '<div class="karzo-option-heading"><h2>' . esc_html__( 'Footer Boxes Area', 'karzo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Manage footer boxes from here', 'karzo' )  ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'footer-boxes-area',
				'label'			=> esc_attr__( 'Show footer boxes?', 'karzo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
			),

			array(
				'type'			=> 'textarea',
				'settings'		=> 'footer-left-area',
				'label'			=> esc_attr__( 'Footer Left Area', 'karzo' ),
				'default'		=> dsvy_esc_kses('[dsvy-social-links]'),
				'active_callback'	=> array( array(
					'setting'			=> 'footer-boxes-area',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),

			// Footer Widget Area
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-widget-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Footer Widget Area', 'karzo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Manage widget area settings', 'karzo' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'footer-column',
				'label'		=> esc_html__( 'Footer Widget Column Type', 'karzo' ),
				'description'	=> esc_html__( 'This will show widgets. You can manage it from "Admin > Appearance > Widgets" section.', 'karzo' ),
				'default'	=> '3-3-3-3',
				'choices'		=> array(
					'12'		=> get_template_directory_uri() . '/includes/images/footer-12.png',
					'6-6'		=> get_template_directory_uri() . '/includes/images/footer-6-6.png',
					'4-4-4'		=> get_template_directory_uri() . '/includes/images/footer-4-4-4.png',
					'3-3-3-3'	=> get_template_directory_uri() . '/includes/images/footer-3-3-3-3.png',
					'2-2-2-6'	=> get_template_directory_uri() . '/includes/images/footer-2-2-2-6.png',
					'6-2-2-2'	=> get_template_directory_uri() . '/includes/images/footer-6-2-2-2.png',
					'8-4'		=> get_template_directory_uri() . '/includes/images/footer-8-4.png',
					'4-8'		=> get_template_directory_uri() . '/includes/images/footer-4-8.png',
					'custom'	=> get_template_directory_uri() . '/includes/images/footer-col-custom.png',
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-1-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 1st Column', 'karzo' ),
				'description'	=> esc_attr__( 'Set custom width of the 1st column in footer widget area', 'karzo' ),
				'default'		=> '34',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-2-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 2nd Column', 'karzo' ),
				'description'	=> esc_attr__( 'Set custom width of the 2nd column in footer widget area', 'karzo' ),
				'default'		=> '544',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-3-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 3rd Column', 'karzo' ),
				'description'	=> esc_attr__( 'Set custom width of the 3rd column in footer widget area', 'karzo' ),
				'default'		=> '22',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-4-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 4th Column', 'karzo' ),
				'description'	=> esc_attr__( 'Set custom width of the 4th column in footer widget area', 'karzo' ),
				'default'		=> '1',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-widget-bgcolor',
				'label'				=> esc_html__( 'Select Footer Widget Area background color', 'karzo' ),
				'default'			=> 'transparent',
				'choices'			=> $pre_color_with_gradient_list,
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'footer-widget-background',
				'label'			=> esc_attr__( 'Footer Widget Area Background', 'karzo' ),
				'description'	=> esc_attr__( 'Background Settings for footer widget area', 'karzo' ),
				'default'		=> array(
					'background-color'		=> '#969696',
				    'background-image'		=> '',
				    'background-repeat'		=> 'repeat',
				    'background-position'	=> 'center center',
				    'background-size'		=> 'cover',
				    'background-attachment'	=> 'scroll',
				),
				'dsvy-output'	=> '.dsvy-footer-widget-area, .dsvy-footer-widget-area.dsvy-bg-color-custom:before',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'footer-widget-color-switch',
				'label'			=> esc_attr__( 'Set Custom Text Color for Widget Area?', 'karzo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-widget-text-color',
				'label'				=> esc_attr__( 'Footer Widget Area Text Color', 'karzo' ),
				'default'			=> 'transparent',
				'choices'			=> $pre_text_color_list,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-widget-color-switch',
						'operator'			=> '==',
						'value'				=> '1',
					)
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-copyright-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Footer Copyright Text Area', 'karzo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Manage bottom footer area from here', 'karzo' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),

			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-copyright-bgcolor',
				'label'				=> esc_html__( 'Select Footer Copyright Area background color', 'karzo' ),
				'default'			=> 'transparent',
				'choices'			=> $pre_color_with_gradient_list,
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'footer-copyright-background',
				'label'			=> esc_attr__( 'Footer Copyright Area Background', 'karzo' ),
				'description'	=> esc_attr__( 'Background Settings for footer copyright area', 'karzo' ),
				'default'		=> array(
					'background-color'		=> '#0a0a0a',
				    'background-image'		=> '',
				    'background-repeat'		=> 'repeat',
				    'background-position'	=> 'center center',
				    'background-size'		=> 'cover',
				    'background-attachment'	=> 'scroll',
				),
				'dsvy-output'	=> '.dsvy-footer-text-area, .dsvy-footer-text-area.dsvy-bg-color-custom:before',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'footer-copyright-color-switch',
				'label'			=> esc_attr__( 'Set Custom Text Color for Copyright Area?', 'karzo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-copyright-text-color',
				'label'				=> esc_attr__( 'Footer Copyright Area Text Color', 'karzo' ),
				'default'			=> 'white',
				'choices'			=> array_merge( array('inherit' => get_template_directory_uri() . '/includes/images/precolor-inherit.png'), $pre_text_color_list ),
				'active_callback'	=> array(
					array(
						'setting'		=> 'footer-copyright-color-switch',
						'operator'		=> '==',
						'value'			=> '1',
					)
				),
			),		
		
			array(
				'type'			=> 'editor',
				'settings'		=> 'copyright-text',
				'label'			=> esc_attr__( 'Footer Copyright Text', 'karzo' ),
				'default'		=> sprintf( esc_attr__( 'Copyright &copy; %1$s %2$s, All Rights Reserved.', 'karzo' ), date('Y'), '<a href="' . esc_url( home_url( '/' ) ) . '">' . get_bloginfo('name') . '</a>' ),
				'priority'		=> 10,
				'partial_refresh'	=> array(
					'copyright-text'		=> array(
						'selector'			=> '.dsvy-footer-copyright-text',
						'render_callback'	=> function() {
							return get_theme_mod('copyright-text');
						},
					)
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-copyright-right-content',
				'label'			=> esc_attr__( 'Footer Right Area', 'karzo' ),
				'description'	=> esc_attr__( 'What you like to show at right side or copyright text', 'karzo' ),
				'default'		=> 'menu',
				'choices'		=> array(
					'social'		=> esc_attr__( 'Show Social Links', 'karzo' ),
					'menu'			=> esc_attr__( 'Show Footer Menu', 'karzo' ),
					'none'			=> esc_attr__( 'None', 'karzo' ),
				),				
			),
		)
	),

	// Social Links Options
	'social_links_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Social Links Options', 'karzo' ),
			'description'	=> esc_attr__( 'You can use [dsvy-social-links] shortcode for social list with icon.', 'karzo' ),
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => $social_options_array
	),
	// Blog Settings
	'blog_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Blog Options', 'karzo' ),
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Blog Settings', 'karzo' ) . '</h2> <span>' . esc_html__( 'Settings for Blogroll, Category, Tag, Archives etc section.', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blogroll-view',
				'label'			=> esc_html__( 'Blogroll view', 'karzo' ),
				'default'		=> 'classic',
				'choices'		=> dsvy_element_template_list('blog', 'customizer'),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blogroll-column',
				'label'			=> esc_html__( 'Blogroll column', 'karzo' ),
				'default'		=> '3',
				'choices'		=> $column_list,
				'active_callback'	=> array(
					array(
						'setting'		=> 'blogroll-view',
						'operator'		=> '!=',
						'value'			=> 'classic',
					)
				),
			),
			array(
			'type'			=> 'switch',
			'settings'		=> 'blog-show-related',
			'label'			=> esc_attr__( 'Show Related Post?', 'karzo' ),
			'default'		=> '0',
			'choices'     => array(
				'on'  => esc_attr__( 'Yes', 'karzo' ),
				'off' => esc_attr__( 'No', 'karzo' ),
			),
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'blog-related-title',
				'label'			=> esc_attr__( 'Related Post Section Title', 'karzo' ), 
				'description'	=> esc_attr__( 'Related Area Title', 'karzo' ),
				'default'		=> esc_attr__( 'Related Post', 'karzo' ),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'blog-related-count',
				'label'			=> esc_attr__( 'How many post you like to show', 'karzo' ),
				'default'		=> 3,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blog-related-column',
				'label'			=>  esc_html__('Related Post Column', 'karzo' ),
				'default'		=> '3',
				'choices'     => $column_list,
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blog-related-style',
				'label'			=> esc_html__( 'Related Post View', 'karzo' ),
				'default'		=> '1',
				'choices'     => $blog_styles,
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-classic-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Blog Classic Settings', 'karzo' ) . '</h2> <span>' . esc_html__( 'Settings for Blog Classic view.', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'blog-classic-limit-switch',
				'label'			=> esc_attr__( 'Limit Content Words for Blog Classic view?', 'karzo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'blog-classic-limit',
				'label'			=> esc_attr__( 'Set Word Limit for Blog Classic view', 'karzo' ),
				'description'	=> esc_attr__( 'This will add limited words before "Read More" link. This is useful if you didn\'t added Read More link in posts.', 'karzo' ),
				'default'		=> 45,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 900,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-classic-limit-switch',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-element-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Blog Style Elements (boxes) Settings', 'karzo' ) . '</h2> <span>' . esc_html__( 'Settings for Blog Style Elements.', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'blog-element-limit-switch',
				'label'			=> esc_attr__( 'Limit Content Words for Blog Element view?', 'karzo' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'blog-element-limit',
				'label'			=> esc_attr__( 'Limit Words for Blog Element view', 'karzo' ),
				'description'	=> esc_attr__( 'This will add limited words before "Read More" link.', 'karzo' ),
				'default'		=> 13,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 900,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-element-limit-switch',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-sidebar-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Sidebar Settings', 'karzo' ) . '</h2> <span>' . esc_html__( 'Select sidebar position Page and Blog section.', 'karzo' ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-post',
				'label'		=> esc_html__( 'Blog Sidebar', 'karzo' ),
				'default'	=> 'right',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
		)
	),
	// Portfolio Settings
	'portfolio_options' => array(
		'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'karzo' ) , $portfolio_cpt_singular_title ) ,
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-portfolio-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Options', 'karzo' ), $portfolio_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Options for Single %1$s Section', 'karzo' ), $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'portfolio-single-style',
				'label'		=> sprintf( esc_html__( '%1$s Single View Style', 'karzo' ), $portfolio_cpt_singular_title ),
				'default'	=> '1',
				'choices'		=> $portfolio_single_style_array,
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-portfolio-detailsbox-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Details Box Options', 'karzo' ), $portfolio_cpt_singular_title ) . '</h2> <span>' . esc_attr__( 'Details Box Settings', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-details-title',
				'label'			=> sprintf( esc_attr__( 'Single %1$s Details Box Title', 'karzo' ), $portfolio_cpt_singular_title ),
				'description'	=> esc_attr__( 'Details Box Title', 'karzo' ),
				'default'		=> esc_attr__( 'Project info', 'karzo' ),
			),
			array(
				'type'			=> 'repeater',
				'label'			=> sprintf( esc_attr__( 'Single %1$s Details Box', 'karzo' ), $portfolio_cpt_singular_title ),
				'row_label'		=> array(
					'type'			=> 'field',
					'value'			=> esc_attr__('Line', 'karzo' ),
					'field'			=> 'line_title',
				),
				'button_label'	=> esc_attr__('Add New Line', 'karzo' ),
				'settings'		=> 'portfolio-details',
				'fields'		=> array(
					'line_title'	=> array(
						'type'			=> 'text',
						'label'			=> esc_attr__( 'Line Title', 'karzo' ),
						'description'	=> esc_attr__( 'This will be the label for the line', 'karzo' ),
						'default'		=> '',
					),
					'line_type'		=> array(
						'type'			=> 'select',
						'label'			=> esc_attr__( 'Line Type', 'karzo' ),
						'description'	=> esc_attr__( 'This will be type for the line', 'karzo' ),
						'default'		=> 'text',
						'choices'		=> array(
							'text'			=> esc_attr__( 'Normal Text', 'karzo' ),
							'category'		=> esc_attr__( 'Category List (without link)', 'karzo' ),
							'category-link'	=> esc_attr__( 'Category List (with link)', 'karzo' ),
						)
					),
				),
				'default'		=> array(
					array(
						'line_title'	=> esc_attr__('Date', 'karzo'),
						'line_type'		=> 'text',
					),
					array(
						'line_title'	=> esc_attr__('Client', 'karzo'),
						'line_type'		=> 'text',
					),
					array(
						'line_title'	=> esc_attr__('Category', 'karzo'),
						'line_type'		=> 'category-link',
					),
					array(
						'line_title'	=> esc_attr__('Address', 'karzo'),
						'line_type'		=> 'text',
					),
    			),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-portfolio-related-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Related %1$s Options', 'karzo' ), $portfolio_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_html__( 'Options for Related %1$s', 'karzo' ), $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'portfolio-show-related',
				'label'			=> sprintf( esc_attr__( 'Show Related %1$s?', 'karzo' ), $portfolio_cpt_singular_title ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-related-title',
				'label'			=> sprintf( esc_attr__( 'Related %1$s Section Title', 'karzo' ), $portfolio_cpt_singular_title ),
				'description'	=> esc_attr__( 'Related Area Title', 'karzo' ),
				'default'		=> sprintf( esc_attr__( 'Related %1$s', 'karzo' ), $portfolio_cpt_singular_title ),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'portfolio-related-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show', 'karzo' ), $portfolio_cpt_singular_title ),
				'default'		=> 3,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-related-column',
				'label'			=> sprintf( esc_html__( 'Related %1$s Column', 'karzo' ), $portfolio_cpt_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-related-style',
				'label'			=> sprintf( esc_html__( 'Related %1$s View', 'karzo' ), $portfolio_cpt_singular_title ),
				'default'		=> '2',
				'choices'		=> dsvy_element_template_list('portfolio', true),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-portfolio-cat-view',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Element View Style for %1$s', 'karzo' ), $portfolio_cat_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Select view style for elements on %1$s', 'karzo' ) , $portfolio_cat_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-cat-style',
				'label'			=> sprintf( esc_html__( 'Element View on %1$s', 'karzo' ), $portfolio_cat_singular_title ),
				'default'		=> '1',
				'choices'		=> dsvy_element_template_list('portfolio', true),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-cat-column',
				'label'			=> sprintf( esc_html__( '%1$s View Column', 'karzo' ), $portfolio_cat_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'portfolio-cat-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show on single %2$s page', 'karzo' ), $portfolio_cpt_singular_title, $portfolio_cat_singular_title ),
				'default'		=> 9,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-portfolio-sidebar-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Sidebar Options', 'karzo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'karzo' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-portfolio',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'karzo' ), $portfolio_cpt_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-portfolio-category',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'karzo' ), $portfolio_cat_singular_title ),
				'default'	=> 'right',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Advanced Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'portfolio-advanced-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Advanced Options', 'karzo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'karzo' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'karzo' ) , $portfolio_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'karzo' ),
				'default'		=> esc_attr__( 'Portfolio', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'karzo' ) , $portfolio_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'karzo' ),
				'default'		=> esc_attr__( 'Portfolio', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cpt-slug',
				'label'			=> sprintf( esc_attr__( '%1$s Section URl Slug', 'karzo' ) , $portfolio_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT URL slug.', 'karzo' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'karzo' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'karzo' ), dsvy_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'portfolio' ),
				'priority'		=> 10,
			),
			// Portfolio Category
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cat-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'karzo' ) , $portfolio_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'karzo' ),
				'default'		=> esc_attr__( 'Portfolio Categories', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cat-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'karzo' ) , $portfolio_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'karzo' ),
				'default'		=> esc_attr__( 'Portfolio Category', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cat-slug',
				'label'			=> sprintf( esc_attr__( '%1$s URl Slug', 'karzo' ) , $portfolio_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy URL slug', 'karzo' ),
				'description'	=> esc_attr__( 'Taxonomy URL slug.', 'karzo' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'karzo' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'karzo' ), dsvy_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'priority'		=> 10,
			),
		)
	),
	// Service Settings
	'service_options' => array(
		'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'karzo' ) , $service_cpt_singular_title ) ,
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-service-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Options', 'karzo' ), $service_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'karzo' ), $service_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'service-single-style',
				'label'		=> sprintf( esc_html__( '%1$s Single View Style', 'karzo' ), $service_cpt_singular_title ),
				'default'	=> '1',
				'choices'		=> $service_single_style_array,
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'service-single-image-hide',
				'label'			=> sprintf( esc_attr__( 'Hide Featured Image on Single %1$s page? ', 'karzo' ), $service_cpt_singular_title ),
				'default'		=> '0',
				'choices'     => array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
				'active_callback' => array(
					array(
						'setting'	=> 'service-single-style',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'service-show-related',
				'label'			=> sprintf( esc_attr__( 'Show Related %1$s', 'karzo' ), $service_cpt_singular_title ),
				'default'		=> '0',
				'choices'     => array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
			),
			array(
			'type'			=> 'text',
			'settings'		=> 'service-related-title',
			'label'			=> sprintf( esc_attr__( 'Related %1$s Section Title', 'karzo' ), $service_cpt_singular_title ),
			'description'	=> esc_attr__( 'Related Area Title', 'karzo' ),
			'default'		=> sprintf( esc_attr__( 'Related %1$s', 'karzo' ), $service_cpt_singular_title ),
			'active_callback' => array(
				array(
					'setting'	=> 'service-show-related',
					'operator'	=> '==',
					'value'		=> '1',
				),
			),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'service-related-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show', 'karzo' ), $service_cpt_singular_title ),
				'default'		=> 3,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'service-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-related-column',
				'label'			=> sprintf( esc_html__( 'Related %1$s Column', 'karzo' ), $service_cpt_singular_title ),
				'default'		=> '3',
				'choices'     => $column_list,
				'active_callback' => array(
					array(
						'setting'	=> 'service-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-related-style',
				'label'			=> sprintf( esc_html__( 'Related %1$s View', 'karzo' ), $service_cpt_singular_title ),
				'default'		=> '2',
				'choices'     => dsvy_element_template_list('service', true),
				'active_callback' => array(
					array(
						'setting'	=> 'service-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-service-cat-view',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Element View Style for %1$s', 'karzo' ), $service_cat_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Select view style for elements on %1$s', 'karzo' ) , $service_cat_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-cat-style',
				'label'			=> sprintf( esc_html__( 'Element View on %1$s', 'karzo' ), $service_cat_singular_title ),
				'default'		=> '1',
				'choices'		=> dsvy_element_template_list('service', true),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-cat-column',
				'label'			=> sprintf( esc_html__( '%1$s View Column', 'karzo' ), $service_cat_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'service-cat-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show on single %2$s page', 'karzo' ), $service_cpt_singular_title, $service_cat_singular_title ),
				'default'		=> 9,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-service-sidebar-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Sidebar Options', 'karzo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'karzo' ) , $service_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-service',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'karzo' ), $service_cpt_singular_title ),
				'default'	=> 'left',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-service-category',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'karzo' ), $service_cat_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Advanced - Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'service-advanced-heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Advanced Options', 'karzo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'karzo' ) , $service_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'karzo' ) , $service_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'karzo' ),
				'default'		=> esc_attr__( 'Service', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'karzo' ) , $service_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'karzo' ),
				'default'		=> esc_attr__( 'Service', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cpt-slug',
				'label'			=> sprintf( esc_attr__( '%1$s Section URl Slug', 'karzo' ) , $service_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT URL slug.', 'karzo' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'karzo' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'karzo' ), dsvy_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'service' ),
				'priority'		=> 10,
			),
			// Service Category
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cat-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'karzo' ) , $service_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'karzo' ),
				'default'		=> esc_attr__( 'Service Categories', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cat-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'karzo' ) , $service_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'karzo' ),
				'default'		=> esc_attr__( 'Service Category', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cat-slug',
				'label'			=> sprintf( esc_attr__( '%1$s URl Slug', 'karzo' ) , $service_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy URL slug.', 'karzo' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'karzo' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'karzo' ), dsvy_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'service-category' ),
				'priority'		=> 10,
			),
		)
	),
	// Team Member Settings
	'team_options' => array(
			'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'karzo' ) , $team_cpt_singular_title ) ,
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-team-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Options', 'karzo' ), $team_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'karzo' ), $team_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'team-single-style',
				'label'		=> sprintf( esc_html__( '%1$s Single View Style', 'karzo' ), $team_cpt_singular_title ),
				'default'	=> '1',
				'choices'		=> $team_single_style_array,
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-team-group-view',
				'default'		=> '<div class="designervily-option-heading"><h2>' . sprintf( esc_html__( 'Element View Style for %1$s', 'karzo' ), $team_group_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Select view style for elements on %1$s', 'karzo' ) , $team_group_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'team-group-style',
				'label'			=> sprintf( esc_html__( 'Element View on %1$s', 'karzo' ), $team_group_singular_title ),
				'default'		=> '1',
				'choices'		=> dsvy_element_template_list('team', true),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'team-group-column',
				'label'			=> sprintf( esc_html__( '%1$s View Column', 'karzo' ), $team_group_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'team-group-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show on single %2$s page', 'karzo' ), $team_cpt_singular_title, $team_group_singular_title ),
				'default'		=> 9,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-team-member-sidebar-settings',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Sidebar Options', 'karzo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'karzo' ) , $team_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-team-member',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'karzo' ), $team_cpt_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-team-group',
				'label'		=> sprintf( esc_html__( '%1$s Sidebar', 'karzo' ), $team_group_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'team_advanced_heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Advanced Options', 'karzo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'karzo' ) , $team_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'karzo' ) , $team_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'karzo' ),
				'default'		=> esc_attr__( 'Team Members', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'karzo' ) , $team_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'karzo' ),
				'default'		=> esc_attr__( 'Team Member', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-cpt-slug',
				'label'			=> sprintf( esc_attr__( '%1$s Section URl Slug', 'karzo' ) , $team_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT URL slug.', 'karzo' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'karzo' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'karzo' ), dsvy_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'team' ),
				'priority'		=> 10,
			),
			// Team Member group
			array(
				'type'			=> 'text',
				'settings'		=> 'team-group-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'karzo' ) , $team_group_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'karzo' ),
				'default'		=> esc_attr__( 'Team Groups', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-group-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'karzo' ) , $team_group_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'karzo' ),
				'default'		=> esc_attr__( 'Team Group', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-group-slug',
				'label'			=> sprintf( esc_attr__( '%1$s URl Slug', 'karzo' ) , $team_group_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy URL slug.', 'karzo' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'karzo' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'karzo' ), dsvy_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'team-group' ),
				'priority'		=> 10,
			),
		)
	),
	// Testimonial Settings
	'testimonial_options' => array(
		'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'karzo' ) , $testimonial_cpt_singular_title ) ,
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'testimonial_advanced_heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Advanced Options', 'karzo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'karzo' ) , $testimonial_cpt_singular_title ) . '</span></div>',
			),

			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'karzo' ) , $testimonial_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'karzo' ),
				'default'		=> esc_attr__( 'Testimonials', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'karzo' ) , $testimonial_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'karzo' ),
				'default'		=> esc_attr__( 'Testimonial', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cat-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'karzo' ) , $testimonial_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'karzo' ),
				'default'		=> esc_attr__( 'Testimonial Categories', 'karzo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cat-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'karzo' ) , $testimonial_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'karzo' ),
				'default'		=> esc_attr__( 'Testimonial Category', 'karzo' ),
				'priority'		=> 10,
			),
		)
	),
	// Search Settings
	'search_results_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Search Results options', 'karzo' ),
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'search_results_heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Search Results Settings', 'karzo' ) . '</h2> <span>' . esc_attr__( 'Settings for Search Results page', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'no-results-title',
				'label'			=> esc_attr__( 'Title for "No Search Results" page', 'karzo' ),
				'description'	=> esc_attr__( 'Title to show when there is no search results', 'karzo' ),
				'default'		=> esc_attr__( 'No Results Found', 'karzo' ),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'no-results-text',
				'label'			=> esc_attr__( 'Text for "No Search Results" page', 'karzo' ),
				'description'	=> esc_attr__( 'Text to show when there is no search results', 'karzo' ),
				'default'		=> esc_attr__('Sorry, but nothing matched your search terms. Please try again with some different keywords.','karzo'),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'search-sidebar-options',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Sidebar Settings', 'karzo' ) . '</h2> <span>' . esc_html__( 'Select sidebar position for search results page.', 'karzo' ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-search',
				'label'		=> esc_html__( 'Search Results Sidebar', 'karzo' ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
		)
	),
	// Error 404 Settings
	'error_404_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Error 404 options', 'karzo' ),
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'error_404_heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Error 404 Settings', 'karzo' ) . '</h2> <span>' . esc_attr__( 'Settings for error 404 page', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'error-404-heading',
				'label'			=> esc_attr__( 'Error 404 Heading', 'karzo' ),
				'description'	=> esc_attr__( 'This is heading for 404 page', 'karzo' ),
				'default'		=> esc_attr__( '404', 'karzo' ),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'error-404-text',
				'label'			=> esc_attr__( 'Error 404 Text', 'karzo' ),
				'description'	=> esc_attr__( 'This is text for 404 page', 'karzo' ),
				'default'		=> esc_attr__( 'OOPS! THE PAGE YOU WERE LOOKING FOR, COULDN\'T BE FOUND.', 'karzo' ),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'error-404-show-search',
				'label'			=> esc_attr__( 'Show search form on 404 page', 'karzo' ),
				'default'		=> '1',
				'priority'		=> 10,
				'choices'		=> array(
					'on'			=> esc_attr__( 'Yes', 'karzo' ),
					'off'			=> esc_attr__( 'No', 'karzo' ),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'error_404_text_custom',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Error 404 Text Color', 'karzo' ) . '</h2> <span>' . esc_attr__( 'Settings for text color for 404 error page', 'karzo' ) . '</span></div>',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'e404-text-color',
				'label'				=> esc_attr__( 'Select 404 page text color', 'karzo' ),
				'default'			=> 'blackish',
				'choices'			=> $pre_text_color_2_list,
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'error_404_bg_custom',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Error 404 Background Option', 'karzo' ) . '</h2> <span>' . esc_attr__( 'Settings for background color/image for 404 error page', 'karzo' ) . '</span></div>',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'e404-bgcolor',
				'label'				=> esc_html__( 'Select 404 page background color', 'karzo' ),
				'default'			=> 'custom',
				'choices'			=> $pre_color_list,
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'e404-background',
				'label'			=> esc_attr__( 'Background', 'karzo' ),
				'description'	=> esc_attr__( 'Background Settings', 'karzo' ),
				'default'		=> array(				
					'background-color'      => 'rgba(255,255,255,0.64)',
					'background-repeat'     => 'no-repeat',
					'background-position'   => 'center center',
					'background-size'       => 'cover',
					'background-attachment' => 'scroll',
				),
				'dsvy-output'	=> '.error404 .site-content-wrap, .error404 .dsvy-bg-color-custom > .site-content-wrap:before',
			),
		)
	),
	// Login Page Settings
	'login_page_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Login Page options', 'karzo' ),
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'login_page_heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Login Page Settings', 'karzo' ) . '</h2> <span>' . esc_attr__( 'Settings for Login Page page', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'custom-login-logo',
				'label'			=> esc_attr__( 'Show different logo?', 'karzo' ),
				'description'	=> esc_attr__( 'Show different logo then the default logo you selected for your site.', 'karzo' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'karzo' ),
					'off' => esc_attr__( 'No', 'karzo' ),
				),
			),
			array(
				'type'				=> 'image',
				'settings'			=> 'login-logo',
				'label'				=> esc_attr__( 'Login Page Custom Logo', 'karzo' ),
				'description'		=> esc_attr__( 'Select logo for the login page', 'karzo' ),
				'default'			=> get_template_directory_uri() . '/images/logo.png',
				'active_callback'	=> array( array(
					'setting'			=> 'custom-login-logo',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'login-page-background',
				'label'			=> esc_attr__( 'Login Page Background', 'karzo' ),
				'description'	=> esc_attr__( 'Background Settings for the login page', 'karzo' ),
				'default'		=> array(				
					'background-color'      => '#444444',
					'background-repeat'     => 'no-repeat',
					'background-position'   => 'center top',
					'background-size'       => 'cover',
					'background-attachment' => 'scroll',
				),
			),
		)
	),
	// Custom CSS/JS Options
	'custom_code_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'CSS/JS Code', 'karzo' ),
			'panel'			=> 'karzo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'tracking_js_heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Tracking Code', 'karzo' ) . '</h2> <span>' . esc_attr__( 'Code for Google Tracking or other ', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'tracking-code',
				'label'			=> esc_attr__( 'Tracking Code', 'karzo' ),
				'description'	=> esc_attr__( 'This code will be added to HEAD element on your all pages.', 'karzo' ),
				'default'		=> '',
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'cust_css_heading',
				'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Custom CSS Code', 'karzo' ) . '</h2> <span>' . esc_attr__( 'Custom CSS Code', 'karzo' ) . '</span></div>',
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'css-code',
				'label'			=> esc_attr__( 'Custom CSS Code', 'karzo' ),
				'description'	=> esc_attr__( 'Add your custom CSS code here.', 'karzo' ),
				'default'		=> '',
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'js-code',
				'label'			=> esc_attr__( 'Custom JS Code', 'karzo' ),
				'description'	=> esc_attr__( 'Add your custom JS code here.', 'karzo' ),
				'default'		=> '',
			),
		)
	),
);
// adding WooCommerce options
if( function_exists('is_woocommerce') ){
	$kirki_options_array2 = array();
	foreach( $kirki_options_array as $sections=>$settings ){
		$kirki_options_array2[$sections] = $settings;
		if( $sections == 'portfolio_options' ){
			$kirki_options_array2['woocommerce_options'] = array(
				'section_settings' => array(
					'title'			=> esc_attr__( 'WooCommerce Options', 'karzo' ),
					'panel'			=> 'karzo_base_options',
					'priority'		=> 160,
				),
				'section_fields' => array(
					// Heading Options
					array(
						'type'		=> 'radio-image',
						'settings'	=> 'sidebar-wc-shop',
						'label'		=> esc_html__( 'WooCommerce Shop Sidebar', 'karzo' ),
						'default'	=> 'right',
						'choices'		=> array(
							'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
							'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
							'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
						),
					),
					array(
						'type'		=> 'radio-image',
						'settings'	=> 'sidebar-wc-single',
						'label'		=> esc_html__( 'WooCommerce Single Product Sidebar', 'karzo' ),
						'default'	=> 'no',
						'choices'		=> array(
							'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
							'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
							'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
						),
					),
					array(
						'type'		=> 'text',
						'settings'	=> 'wc-title',
						'label'		=> esc_attr__( 'WooCommerce Shop Page Title', 'karzo' ),
						'description'	=> esc_attr__( 'This will appear in Titlebar on Shop page.', 'karzo' ),
						'default'	=> esc_attr('Shop'),
					),
					array(
						'type'			=> 'select',
						'settings'		=> 'wc-related-count',
						'label'			=> esc_attr__( 'How many related products will be shown?', 'karzo' ),
						'description'	=> esc_attr__( 'How many related products will be shown on single product page?', 'karzo' ),
						'default'		=> '3',
						'choices'		=> array(
							'1'		=> esc_attr__( '1 product', 'karzo' ),
							'2'		=> esc_attr__( '2 products', 'karzo' ),
							'3'		=> esc_attr__( '3 products', 'karzo' ),
							'4'		=> esc_attr__( '4 products', 'karzo' ),
						),
					),
					array(
						'type'			=> 'switch',
						'settings'		=> 'wc-show-cart-icon',
						'label'			=> esc_attr__( 'Show Cart Icon in Header?', 'karzo' ),
						'description'	=> esc_attr__( 'Show or hide cart icon in header area. The icon will appear only if WooCommerce plugin is active.', 'karzo' ),
						'default'		=> '1',
						'choices'		=> array(
							'on'		=> esc_attr__( 'Yes', 'karzo' ),
							'off'		=> esc_attr__( 'No', 'karzo' ),
						),
					),
					array(
						'type'			=> 'switch',
						'settings'		=> 'wc-show-cart-amount',
						'label'			=> esc_attr__( 'Show Amount with Cart Icon in Header?', 'karzo' ),
						'description'	=> esc_attr__( 'Show or hide cart amount with cart icon in header area. The icon will appear only if WooCommerce plugin is active.', 'karzo' ),
						'default'		=> '0',
						'choices'		=> array(
							'on'		=> esc_attr__( 'Yes', 'karzo' ),
							'off'		=> esc_attr__( 'No', 'karzo' ),
						),
						'active_callback' => array( array(
							'setting'		=> 'wc-show-cart-icon',
							'operator'		=> '==',
							'value'			=> '1',
						) ),
					),
				)
			);
		}
	} // foreach
	$kirki_options_array = $kirki_options_array2;
}

// adding Event options
if( class_exists('WP_Event_Manager') ){
	$kirki_options_array3 = array();
	foreach( $kirki_options_array as $sections=>$settings ){
		$kirki_options_array3[$sections] = $settings;
		if( $sections == 'portfolio_options' ){
			$kirki_options_array3['event_options'] = array(
				'section_settings' => array(
					'title'			=> esc_attr__( 'Event Options', 'karzo' ),
					'panel'			=> 'karzo_base_options',
					'priority'		=> 160,
				),
				'section_fields' => array(
					// Heading Options
					array(
						'type'			=> 'custom',
						'settings'		=> 'custom-event-column-options',
						'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Column Settings', 'karzo' ) . '</h2> <span>' . esc_html__( 'Select column for the Event listing.', 'karzo' ) . '</span></div>',
					),
					array(
						'type'		=> 'radio-image',
						'settings'	=> 'event-column',
						'label'		=> esc_html__( 'Event Column', 'karzo' ),
						'description'	=> esc_html__( 'Select column structure for Event', 'karzo' ),
						'default'	=> '3-3-3-3',
						'choices'		=> array(
							'12'		=> get_template_directory_uri() . '/includes/images/footer-12.png',
							'6-6'		=> get_template_directory_uri() . '/includes/images/footer-6-6.png',
							'4-4-4'		=> get_template_directory_uri() . '/includes/images/footer-4-4-4.png',
							'3-3-3-3'	=> get_template_directory_uri() . '/includes/images/footer-3-3-3-3.png',
						),
					),

					// Heading Options
					array(
						'type'			=> 'custom',
						'settings'		=> 'custom-event-sidebar-options',
						'default'		=> '<div class="designervily-option-heading"><h2>' . esc_html__( 'Sidebar Settings', 'karzo' ) . '</h2> <span>' . esc_html__( 'Select sidebar position for Event section.', 'karzo' ) . '</span></div>',
					),
					array(
						'type'		=> 'radio-image',
						'settings'	=> 'sidebar-event',
						'label'		=> esc_html__( 'Event Sidebar', 'karzo' ),
						'default'	=> 'right',
						'choices'		=> array(
							'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
							'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
							'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
						),
					),
					array(
						'type'		=> 'radio-image',
						'settings'	=> 'sidebar-event-single',
						'label'		=> esc_html__( 'Event Single Sidebar', 'karzo' ),
						'default'	=> 'no',
						'choices'		=> array(
							'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
							'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
							'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
						),
					),
				)
			);
		}
	} // foreach
	$kirki_options_array = $kirki_options_array3;
}