<?php
/*
Plugin Name: Karzo Theme Addons
Plugin URI: https://designervily.com/
Description: Addons for Karzo theme by Designervily
Version: 1.9
Author: Designervily Team
Author URI: https://designervily.com/
Text Domain: karzo-addons
Domain Path: /language
*/

// security
if( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

define( 'KARZO_ADDON_VERSION', '1.9' );
define( 'KARZO_ADDON_PATH', plugin_dir_path( __FILE__ ) ); // with trailing slash
define( 'KARZO_ADDON_URL',  plugin_dir_url( __FILE__ )  ); // with trailing slash

/*
 *  All Shortcodes
 */
if( file_exists( KARZO_ADDON_PATH . '/shortcodes/dsvy-social-links.php' ) ){
	include( KARZO_ADDON_PATH . '/shortcodes/dsvy-social-links.php' );
}
if( file_exists( KARZO_ADDON_PATH . '/shortcodes/karzo-current-year.php' ) ){
	include( KARZO_ADDON_PATH . '/shortcodes/karzo-current-year.php' );
}
if( file_exists( KARZO_ADDON_PATH . '/shortcodes/karzo-site-url.php' ) ){
	include( KARZO_ADDON_PATH . '/shortcodes/karzo-site-url.php' );
}
if( file_exists( KARZO_ADDON_PATH . '/shortcodes/karzo-site-title.php' ) ){
	include( KARZO_ADDON_PATH . '/shortcodes/karzo-site-title.php' );
}
if( file_exists( KARZO_ADDON_PATH . '/shortcodes/karzo-site-tagline.php' ) ){
	include( KARZO_ADDON_PATH . '/shortcodes/karzo-site-tagline.php' );
}

// Core functions
if( file_exists( get_template_directory() . '/includes/core.php' ) ){
	include( get_template_directory() . '/includes/core.php' );
} else {
	include( KARZO_ADDON_PATH . 'core.php' );
}

/**
 *  W3 Validator warning The type attribute is unnecessary
 */
add_action( 'template_redirect', function(){
    ob_start( function( $buffer ){
        $buffer = str_replace( array( '<script type="text/javascript"', "<script type='text/javascript'" ), '<script', $buffer );

        // Also works with other attributes...
        $buffer = str_replace( array( '<style type="text/css"', "<style type='text/css'" ), '<style', $buffer );
        $buffer = str_replace( array( ' type="text/css">', " type='text/css'>" ), '>', $buffer );
        $buffer = str_replace( array( 'frameborder="0"', "frameborder='0'" ), '', $buffer );
        $buffer = str_replace( array( 'scrolling="no"', "scrolling='no'" ), '', $buffer );

        return $buffer;
    });
});

if( !function_exists('dsvy_karzo_addons_init') ){
function dsvy_karzo_addons_init(){
	// Kirki - disable the telemetry module 
	add_filter( 'kirki_telemetry', '__return_false' );
}
}
add_action( 'init', 'dsvy_karzo_addons_init' );

add_action( 'customize_save_after', 'dsvy_karzo_addons_create_css', 10, 2 );
if( !function_exists('dsvy_karzo_addons_create_css') ){
function dsvy_karzo_addons_create_css( $data=array() ) {
	if( file_exists( get_template_directory() . '/css/theme-style.php' ) ){
		$content = '';
		ob_start();
		include( get_template_directory() . '/css/theme-style.php' );
		$content = ob_get_contents();
		ob_end_clean();

		// get site ID if multisite
		$blog_id = '';

		$css_dir_path	= ( is_multisite() ) ? WP_CONTENT_DIR . '/dsvy-karzo-css/' . get_current_blog_id() . '/' : WP_CONTENT_DIR . '/dsvy-karzo-css/' ;
		$css_path		= ( is_multisite() ) ? WP_CONTENT_DIR . '/dsvy-karzo-css/' . get_current_blog_id() . '/theme-style.css' : WP_CONTENT_DIR . '/dsvy-karzo-css/theme-style.css' ;
		$css_min_path	= ( is_multisite() ) ? WP_CONTENT_DIR . '/dsvy-karzo-css/' . get_current_blog_id() . '/theme-style.min.css' : WP_CONTENT_DIR . '/dsvy-karzo-css/theme-style.min.css' ;

		// create directory if not exists
		wp_mkdir_p( $css_dir_path );

		if( !function_exists('WP_Filesystem') ){
			require_once(ABSPATH . 'wp-admin/includes/file.php');
		}

		WP_Filesystem();
		global $wp_filesystem;
		$wp_filesystem->put_contents( $css_path, $content );
		$wp_filesystem->put_contents( $css_min_path, dsvy_minify_css($content) );

		// add unique version code for this css file
		$version = rand(100,999) . rand(100,999);
		update_option( 'dsvy-theme-style-version', $version );

	}
	return $data;
}
}

if( !function_exists('dsvy_karzo_check_dynamic_css') ){
function dsvy_karzo_check_dynamic_css(){
	$dsvy_theme_version		= get_option('dsvy-karzo-theme-version');
	$current_theme			= wp_get_theme();
	$current_theme_version	= $current_theme->Version;
	if( $dsvy_theme_version != $current_theme_version ){
		dsvy_karzo_addons_create_css();
		update_option( 'dsvy-karzo-theme-version', $current_theme_version );
	}
}
}
add_action( 'wp', 'dsvy_karzo_check_dynamic_css', 26 );

// Generate dynamic style css file
if( !function_exists('dsvy_karzo_auto_generate_dynamic_css') ){
function dsvy_karzo_auto_generate_dynamic_css(){
	$min				= ( defined('WP_DEBUG') && true === WP_DEBUG ) ?  '' : '.min' ;
	$version			= get_option('dsvy-theme-style-version', '111111');

	$css_path		= ( is_multisite() ) ? WP_CONTENT_DIR . '/dsvy-karzo-css/' . get_current_blog_id() . '/theme-style.css' : WP_CONTENT_DIR . '/dsvy-karzo-css/theme-style.css' ;
	$css_min_path	= ( is_multisite() ) ? WP_CONTENT_DIR . '/dsvy-karzo-css/' . get_current_blog_id() . '/theme-style.min.css' : WP_CONTENT_DIR . '/dsvy-karzo-css/theme-style.min.css' ;
	$css_url		= ( is_multisite() ) ? content_url() . '/dsvy-karzo-css/' . get_current_blog_id() . '/theme-style' . $min . '.css' : content_url() . '/dsvy-karzo-css/theme-style' . $min . '.css' ;

	if( function_exists('dsvy_karzo_addons_create_css') && ( !file_exists($css_path) || !file_exists($css_min_path) ) ){
		dsvy_karzo_addons_create_css();
	}
	if( function_exists('is_customize_preview') && !is_customize_preview() && defined('WP_DEBUG') && true !== WP_DEBUG ){
		wp_deregister_style( 'dsvy-dynamic-style' );
		wp_enqueue_style('dsvy-dynamic-style', esc_url($css_url), '', $version );
	}

	// For inline css
	global $dsvy_inline_css;
	if( !empty($dsvy_inline_css) ){
		if( function_exists('dsvy_minify_css') ){
			$dsvy_inline_css = dsvy_minify_css( $dsvy_inline_css );
		}
		wp_add_inline_style( 'dsvy-dynamic-style', trim( $dsvy_inline_css ) );
	}

	if( wp_style_is( 'elementor-global', 'enqueued' ) ){
		wp_deregister_style( 'elementor-global' );
	}

}
}
add_action( 'wp_enqueue_scripts', 'dsvy_karzo_auto_generate_dynamic_css', 26 );

/**
 * Register a book post type.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_post_type
 */
if( !function_exists('karzo_addons_register_post_types') ){
function karzo_addons_register_post_types() {

	// Default titles
	$portfolio_cpt_title			= esc_attr__('Portfolio','karzo-addons');
	$portfolio_cpt_singular_title	= esc_attr__('Portfolio','karzo-addons');
	$portfolio_cpt_slug				= esc_attr('portfolio');

	$portfolio_cat_title			= esc_attr__('Portfolio Categories','karzo-addons');
	$portfolio_cat_singular_title	= esc_attr__('Portfolio Category','karzo-addons');
	$portfolio_cat_slug				= esc_attr('portfolio-category');

	$service_cpt_title				= esc_attr__('Services','karzo-addons');
	$service_cpt_singular_title		= esc_attr__('Service','karzo-addons');
	$service_cpt_slug				= esc_attr('service');

	$service_cat_title				= esc_attr__('Service Categories','karzo-addons');
	$service_cat_singular_title		= esc_attr__('Service Category','karzo-addons');
	$service_cat_slug				= esc_attr__('service-category');

	$team_cpt_title					= esc_attr__('Team Members','karzo-addons');
	$team_cpt_singular_title		= esc_attr__('Team Member','karzo-addons');
	$team_cpt_slug					= esc_attr('team-member');

	$team_group_title				= esc_attr__('Team Groups','karzo-addons');
	$team_group_singular_title		= esc_attr__('Team Group','karzo-addons');
	$team_group_slug				= esc_attr('team-group');

	$testimonial_cpt_title			= esc_attr__('Testimonials','karzo-addons');
	$testimonial_cpt_singular_title	= esc_attr__('Testimonial','karzo-addons');
	$testimonial_cpt_slug			= esc_attr('testimonial');

	$testimonial_cat_title			= esc_attr__('Testimonial Categories','karzo-addons');
	$testimonial_cat_singular_title	= esc_attr__('Testimonial Category','karzo-addons');
	$testimonial_cat_slug				= esc_attr('testimonial-category');

	if( class_exists('Kirki') ){

		// Portfolio
		$portfolio_cpt_title2	= Kirki::get_option( 'portfolio-cpt-title' );
		$portfolio_cpt_title	= ( !empty($portfolio_cpt_title2) ) ? $portfolio_cpt_title2 : $portfolio_cpt_title ;

		// Portfolio - singular
		$portfolio_cpt_singular_title2	= Kirki::get_option( 'portfolio-cpt-singular-title' );
		$portfolio_cpt_singular_title	= ( !empty($portfolio_cpt_singular_title2) ) ? $portfolio_cpt_singular_title2 : $portfolio_cpt_singular_title ;

		// Portfolio Slug
		$portfolio_cpt_slug2	= Kirki::get_option( 'portfolio-cpt-slug' );
		$portfolio_cpt_slug	= ( !empty($portfolio_cpt_slug2) ) ? $portfolio_cpt_slug2 : $portfolio_cpt_slug ;

		// Portfolio Category
		$portfolio_cat_title2	= Kirki::get_option( 'portfolio-cat-title' );
		$portfolio_cat_title	= ( !empty($portfolio_cat_title2) ) ? $portfolio_cat_title2 : $portfolio_cat_title ;

		// Portfolio Category - singular
		$portfolio_cat_singular_title2	= Kirki::get_option( 'portfolio-cat-singular-title' );
		$portfolio_cat_singular_title	= ( !empty($portfolio_cat_singular_title2) ) ? $portfolio_cat_singular_title2 : $portfolio_cat_singular_title ;

		// Portfolio Category Slug
		$portfolio_cat_slug2	= Kirki::get_option( 'portfolio-cat-slug' );
		$portfolio_cat_slug	= ( !empty($portfolio_cat_slug2) ) ? $portfolio_cat_slug2 : $portfolio_cat_slug ;

		// Service
		$service_cpt_title2	= Kirki::get_option( 'service-cpt-title' );
		$service_cpt_title	= ( !empty($service_cpt_title2) ) ? $service_cpt_title2 : $service_cpt_title ;

		// Service - singular
		$service_cpt_singular_title2	= Kirki::get_option( 'service-cpt-singular-title' );
		$service_cpt_singular_title	= ( !empty($service_cpt_singular_title2) ) ? $service_cpt_singular_title2 : $service_cpt_singular_title ;

		// Service Slug
		$service_cpt_slug2	= Kirki::get_option( 'service-cpt-slug' );
		$service_cpt_slug	= ( !empty($service_cpt_slug2) ) ? $service_cpt_slug2 : $service_cpt_slug ;

		// Service Category
		$service_cat_title2	= Kirki::get_option( 'service-cat-title' );
		$service_cat_title	= ( !empty($service_cat_title2) ) ? $service_cat_title2 : $service_cat_title ;

		// Service Category - singular
		$service_cat_singular_title2	= Kirki::get_option( 'service-cat-singular-title' );
		$service_cat_singular_title	= ( !empty($service_cat_singular_title2) ) ? $service_cat_singular_title2 : $service_cat_singular_title ;

		// Service Category Slug
		$service_cat_slug2	= Kirki::get_option( 'service-cat-slug' );
		$service_cat_slug	= ( !empty($service_cat_slug2) ) ? $service_cat_slug2 : $service_cat_slug ;

		// Team
		$team_cpt_title2	= Kirki::get_option( 'team-cpt-title' );
		$team_cpt_title	= ( !empty($team_cpt_title2) ) ? $team_cpt_title2 : $team_cpt_title ;

		// Team - singular
		$team_cpt_singular_title2	= Kirki::get_option( 'team-cpt-singular-title' );
		$team_cpt_singular_title	= ( !empty($team_cpt_singular_title2) ) ? $team_cpt_singular_title2 : $team_cpt_singular_title ;

		// Team Slug
		$team_cpt_slug2	= Kirki::get_option( 'team-cpt-slug' );
		$team_cpt_slug	= ( !empty($team_cpt_slug2) ) ? $team_cpt_slug2 : $team_cpt_slug ;

		// Team Group
		$team_group_title2	= Kirki::get_option( 'team-group-title' );
		$team_group_title	= ( !empty($team_group_title2) ) ? $team_group_title2 : $team_group_title ;

		// Team Group - singular
		$team_group_singular_title2	= Kirki::get_option( 'team-group-singular-title' );
		$team_group_singular_title	= ( !empty($team_group_singular_title2) ) ? $team_group_singular_title2 : $team_group_singular_title ;

		// Team Group Slug
		$team_group_slug2	= Kirki::get_option( 'team-group-slug' );
		$team_group_slug	= ( !empty($team_group_slug2) ) ? $team_group_slug2 : $team_group_slug ;

		// Testimonial
		$testimonial_cpt_title2	= Kirki::get_option( 'testimonial-cpt-title' );
		$testimonial_cpt_title	= ( !empty($testimonial_cpt_title2) ) ? $testimonial_cpt_title2 : $testimonial_cpt_title ;

		// Testimonial - singular
		$testimonial_cpt_singular_title2	= Kirki::get_option( 'testimonial-cpt-singular-title' );
		$testimonial_cpt_singular_title	= ( !empty($testimonial_cpt_singular_title2) ) ? $testimonial_cpt_singular_title2 : $testimonial_cpt_singular_title ;

		// Testimonial Category
		$testimonial_cat_title2	= Kirki::get_option( 'testimonial-cat-title' );
		$testimonial_cat_title	= ( !empty($testimonial_cat_title2) ) ? $testimonial_cat_title2 : $testimonial_cat_title ;

		// Testimonial Category - singular
		$testimonial_cat_singular_title2	= Kirki::get_option( 'testimonial-cat-singular-title' );
		$testimonial_cat_singular_title	= ( !empty($testimonial_cat_singular_title2) ) ? $testimonial_cat_singular_title2 : $testimonial_cat_singular_title ;

	}

	/**** CPT - Portfolio ****/
	$portfolio_labels = array(
		'name'               => _x( $portfolio_cpt_title, 'post type general name', 'karzo-addons' ),
		'singular_name'      => _x( $portfolio_cpt_singular_title, 'post type singular name', 'karzo-addons' ),
		'add_new_item'       => sprintf( esc_attr__( 'Add New %1$s', 'karzo-addons' ) , $portfolio_cpt_singular_title ),
		'edit_item'          => sprintf( esc_attr__( 'Edit %1$s', 'karzo-addons' ) , $portfolio_cpt_singular_title ),
		'menu_name'          => _x( $portfolio_cpt_title, 'admin menu ', 'karzo-addons' ),
		'name_admin_bar'     => _x( $portfolio_cpt_singular_title, 'add new on admin bar', 'karzo-addons' ),
		'add_new'            => esc_attr__( 'Add New', 'karzo-addons' ),
		'new_item'           => sprintf( esc_attr__( 'New %1$s', 'karzo-addons' ) , $portfolio_cpt_singular_title ),
		'view_item'          => sprintf( esc_attr__( 'View %1$s', 'karzo-addons' ) , $portfolio_cpt_singular_title ),
		'all_items'          => sprintf( esc_attr__( 'All %1$s', 'karzo-addons' ) , $portfolio_cpt_title ),
		'search_items'       => sprintf( esc_attr__( 'Search %1$s', 'karzo-addons' ) , $portfolio_cpt_title ),
		'parent_item_colon'  => sprintf( esc_attr__( 'Parent %1$s:', 'karzo-addons' ) , $portfolio_cpt_title ),
		'not_found'          => sprintf( esc_attr__( 'No %1$s found', 'karzo-addons' ) , $portfolio_cpt_title ),
		'not_found_in_trash' => sprintf( esc_attr__( 'No %1$s found in Trash.', 'karzo-addons' ) , $portfolio_cpt_title )
	);

	$portfolio_args = array(
		'labels'             => $portfolio_labels,
		'menu_icon'			=> 'dashicons-welcome-widgets-menus',
		//'description'        => __( 'Description.', 'karzo-addons' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => esc_attr($portfolio_cpt_slug) ),  // important
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt', 'custom-fields', 'revisions'  /*'excerpt'*/ )
	);

	register_post_type( 'dsvy-portfolio', $portfolio_args );

	// Add new taxonomy, make it hierarchical (like categories)
	$portfolio_category_labels = array(
		'name'              => _x( $portfolio_cat_title, 'Portfolio Category general name', 'karzo-addons' ),
		'singular_name'     => _x( $portfolio_cat_singular_title, 'Portfolio Category singular name', 'karzo-addons' ),
		'search_items'      => sprintf( esc_attr__( 'Search %1$s', 'karzo-addons' ) , $portfolio_cat_title ),
		'all_items'         => sprintf( esc_attr__( 'All %1$s', 'karzo-addons' ) , $portfolio_cat_title ),
		'parent_item'       => sprintf( esc_attr__( 'Parent %1$s', 'karzo-addons' ) , $portfolio_cat_singular_title ),
		'parent_item_colon' => sprintf( esc_attr__( 'Parent %1$s:', 'karzo-addons' ) , $portfolio_cat_singular_title ),
		'edit_item'         => sprintf( esc_attr__( 'Edit %1$s', 'karzo-addons' ) , $portfolio_cat_singular_title ),
		'update_item'       => sprintf( esc_attr__( 'Update %1$s', 'karzo-addons' ) , $portfolio_cat_singular_title ),
		'add_new_item'      => sprintf( esc_attr__( 'Add New %1$s', 'karzo-addons' ) , $portfolio_cat_singular_title ),
		'new_item_name'     => sprintf( esc_attr__( 'New %1$s Name', 'karzo-addons' ) , $portfolio_cat_singular_title ),
		'menu_name'         => $portfolio_cat_singular_title,
	);

	$portfolio_category_args = array(
		'hierarchical'      => true,
		'labels'            => $portfolio_category_labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => esc_attr($portfolio_cat_slug) ),
	);

	register_taxonomy( 'dsvy-portfolio-category', array( 'dsvy-portfolio' ), $portfolio_category_args );

	/**** CPT - Service ****/
	$service_labels = array(
		'name'               => _x( $service_cpt_title, 'post type general name', 'karzo-addons' ),
		'singular_name'      => _x( $service_cpt_singular_title, 'post type singular name', 'karzo-addons' ),
		'add_new_item'       => sprintf( esc_attr__( 'Add New %1$s', 'karzo-addons' ) , $service_cpt_singular_title ),
		'edit_item'          => sprintf( esc_attr__( 'Edit %1$s', 'karzo-addons' ) , $service_cpt_singular_title ),
		'menu_name'          => _x( $service_cpt_title, 'admin menu ', 'karzo-addons' ),
		'name_admin_bar'     => _x( $service_cpt_singular_title, 'add new on admin bar', 'karzo-addons' ),
		'add_new'            => esc_attr__( 'Add New', 'karzo-addons' ),
		'new_item'           => sprintf( esc_attr__( 'New %1$s', 'karzo-addons' ) , $service_cpt_singular_title ),
		'view_item'          => sprintf( esc_attr__( 'View %1$s', 'karzo-addons' ) , $service_cpt_singular_title ),
		'all_items'          => sprintf( esc_attr__( 'All %1$s', 'karzo-addons' ) , $service_cpt_title ),
		'search_items'       => sprintf( esc_attr__( 'Search %1$s', 'karzo-addons' ) , $service_cpt_title ),
		'parent_item_colon'  => sprintf( esc_attr__( 'Parent %1$s:', 'karzo-addons' ) , $service_cpt_title ),
		'not_found'          => sprintf( esc_attr__( 'No %1$s found', 'karzo-addons' ) , $service_cpt_title ),
		'not_found_in_trash' => sprintf( esc_attr__( 'No %1$s found in Trash.', 'karzo-addons' ) , $service_cpt_title )
	);

	$service_args = array(
		'labels'             => $service_labels,
		'menu_icon'			=> 'dashicons-analytics',
		//'description'        => __( 'Description.', 'karzo-addons' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => esc_attr($service_cpt_slug) ),  // important
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', 'excerpt', 'custom-fields', 'revisions'  /*'excerpt'*/ )
	);

	register_post_type( 'dsvy-service', $service_args );

	// Add new taxonomy, make it hierarchical (like categories)
	$service_category_labels = array(
		'name'              => _x( $service_cat_title, 'Service Category general name', 'karzo-addons' ),
		'singular_name'     => _x( $service_cat_singular_title, 'Service Category singular name', 'karzo-addons' ),
		'search_items'      => sprintf( esc_attr__( 'Search %1$s', 'karzo-addons' ) , $service_cat_title ),
		'all_items'         => sprintf( esc_attr__( 'All %1$s', 'karzo-addons' ) , $service_cat_title ),
		'parent_item'       => sprintf( esc_attr__( 'Parent %1$s', 'karzo-addons' ) , $service_cat_singular_title ),
		'parent_item_colon' => sprintf( esc_attr__( 'Parent %1$s:', 'karzo-addons' ) , $service_cat_singular_title ),
		'edit_item'         => sprintf( esc_attr__( 'Edit %1$s', 'karzo-addons' ) , $service_cat_singular_title ),
		'update_item'       => sprintf( esc_attr__( 'Update %1$s', 'karzo-addons' ) , $service_cat_singular_title ),
		'add_new_item'      => sprintf( esc_attr__( 'Add New %1$s', 'karzo-addons' ) , $service_cat_singular_title ),
		'new_item_name'     => sprintf( esc_attr__( 'New %1$s Name', 'karzo-addons' ) , $service_cat_singular_title ),
		'menu_name'         => $service_cat_singular_title,
	);

	$service_category_args = array(
		'hierarchical'      => true,
		'labels'            => $service_category_labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => esc_attr($service_cat_slug) ),
	);

	register_taxonomy( 'dsvy-service-category', array( 'dsvy-service' ), $service_category_args );

	/**** CPT - Team Member ****/
	$team_members_labels = array(
		'name'               => _x( $team_cpt_title, 'post type general name', 'karzo-addons' ),
		'singular_name'      => _x( $team_cpt_singular_title, 'post type singular name', 'karzo-addons' ),
		'add_new_item'       => sprintf( esc_attr__( 'Add New %1$s', 'karzo-addons' ) , $team_cpt_singular_title ),
		'edit_item'          => sprintf( esc_attr__( 'Edit %1$s', 'karzo-addons' ) , $team_cpt_singular_title ),
		'menu_name'          => _x( $team_cpt_title, 'admin menu ', 'karzo-addons' ),
		'name_admin_bar'     => _x( $team_cpt_singular_title, 'add new on admin bar', 'karzo-addons' ),
		'add_new'            => esc_attr__( 'Add New', 'karzo-addons' ),
		'new_item'           => sprintf( esc_attr__( 'New %1$s', 'karzo-addons' ) , $team_cpt_singular_title ),
		'view_item'          => sprintf( esc_attr__( 'View %1$s', 'karzo-addons' ) , $team_cpt_singular_title ),
		'all_items'          => sprintf( esc_attr__( 'All %1$s', 'karzo-addons' ) , $team_cpt_title ),
		'search_items'       => sprintf( esc_attr__( 'Search %1$s', 'karzo-addons' ) , $team_cpt_title ),
		'parent_item_colon'  => sprintf( esc_attr__( 'Parent %1$s:', 'karzo-addons' ) , $team_cpt_title ),
		'not_found'          => sprintf( esc_attr__( 'No %1$s found', 'karzo-addons' ) , $team_cpt_title ),
		'not_found_in_trash' => sprintf( esc_attr__( 'No %1$s found in Trash.', 'karzo-addons' ) , $team_cpt_title )
	);

	$team_members_args = array(
		'labels'             => $team_members_labels,
		'menu_icon'			=> 'dashicons-id',
		//'description'        => __( 'Description.', 'karzo-addons' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => esc_attr($team_cpt_slug) ),  // important
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail', /* 'excerpt' */ )
	);

	register_post_type( 'dsvy-team-member', $team_members_args );

	// Add new taxonomy, make it hierarchical (like categories)
	$team_member_group_labels = array(
		'name'              => _x( $team_group_title, 'Team Group general name', 'karzo-addons' ),
		'singular_name'     => _x( $team_group_singular_title, 'Team Group singular name', 'karzo-addons' ),
		'search_items'      => sprintf( esc_attr__( 'Search %1$s', 'karzo-addons' ) , $team_group_title ),
		'all_items'         => sprintf( esc_attr__( 'All %1$s', 'karzo-addons' ) , $team_group_title ),
		'parent_item'       => sprintf( esc_attr__( 'Parent %1$s', 'karzo-addons' ) , $team_group_singular_title ),
		'parent_item_colon' => sprintf( esc_attr__( 'Parent %1$s:', 'karzo-addons' ) , $team_group_singular_title ),
		'edit_item'         => sprintf( esc_attr__( 'Edit %1$s', 'karzo-addons' ) , $team_group_singular_title ),
		'update_item'       => sprintf( esc_attr__( 'Update %1$s', 'karzo-addons' ) , $team_group_singular_title ),
		'add_new_item'      => sprintf( esc_attr__( 'Add New %1$s', 'karzo-addons' ) , $team_group_singular_title ),
		'new_item_name'     => sprintf( esc_attr__( 'New %1$s Name', 'karzo-addons' ) , $team_group_singular_title ),
		'menu_name'         => $team_group_singular_title,
	);

	$team_member_group_args = array(
		'hierarchical'      => true,
		'labels'            => $team_member_group_labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => esc_attr($team_group_slug) ),
	);

	register_taxonomy( 'dsvy-team-group', array( 'dsvy-team-member' ), $team_member_group_args );

	/**** CPT - Testimonials ****/
	$testimonial_labels = array(
		'name'               => _x( $testimonial_cpt_title, 'post type general name', 'karzo-addons' ),
		'singular_name'      => _x( $testimonial_cpt_singular_title, 'post type singular name', 'karzo-addons' ),
		'add_new_item'       => sprintf( esc_attr__( 'Add New %1$s', 'karzo-addons' ) , $testimonial_cpt_singular_title ),
		'edit_item'          => sprintf( esc_attr__( 'Edit %1$s', 'karzo-addons' ) , $testimonial_cpt_singular_title ),
		'menu_name'          => _x( $testimonial_cpt_title, 'admin menu ', 'karzo-addons' ),
		'name_admin_bar'     => _x( $testimonial_cpt_singular_title, 'add new on admin bar', 'karzo-addons' ),
		'add_new'            => esc_attr__( 'Add New', 'karzo-addons' ),
		'new_item'           => sprintf( esc_attr__( 'New %1$s', 'karzo-addons' ) , $testimonial_cpt_singular_title ),
		'view_item'          => sprintf( esc_attr__( 'View %1$s', 'karzo-addons' ) , $testimonial_cpt_singular_title ),
		'all_items'          => sprintf( esc_attr__( 'All %1$s', 'karzo-addons' ) , $testimonial_cpt_title ),
		'search_items'       => sprintf( esc_attr__( 'Search %1$s', 'karzo-addons' ) , $testimonial_cpt_title ),
		'parent_item_colon'  => sprintf( esc_attr__( 'Parent %1$s:', 'karzo-addons' ) , $testimonial_cpt_title ),
		'not_found'          => sprintf( esc_attr__( 'No %1$s found', 'karzo-addons' ) , $testimonial_cpt_title ),
		'not_found_in_trash' => sprintf( esc_attr__( 'No %1$s found in Trash.', 'karzo-addons' ) , $testimonial_cpt_title ),
		'featured_image'		=> sprintf( esc_attr__( '%1$s writer\'s image/logo', 'karzo-addons' ) , $testimonial_cpt_singular_title ),
		'set_featured_image'	=> esc_attr__( 'Set image/logo', 'karzo-addons' ),
		'remove_featured_image'	=> esc_attr__( 'Remove image/logo', 'karzo-addons' ),
		'use_featured_image'	=> sprintf( esc_attr__( 'Use as %1$s writer\'s image/logo', 'karzo-addons' ) , $testimonial_cpt_singular_title ),

	);

	$testimonial_args = array(
		'labels'             => $testimonial_labels,
		'menu_icon'			=> 'dashicons-testimonial',
		'public'             => false,
		'publicly_queryable' => false,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => esc_attr($testimonial_cpt_slug) ),  // important
		'capability_type'    => 'post',
		'has_archive'        => false,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail' )
	);

	register_post_type( 'dsvy-testimonial', $testimonial_args );

	// Add new taxonomy, make it hierarchical (like categories)
	$testimonial_cat_labels = array(
		'name'              => _x( $testimonial_cat_title, 'Team Group general name', 'karzo-addons' ),
		'singular_name'     => _x( $testimonial_cat_singular_title, 'Team Group singular name', 'karzo-addons' ),
		'search_items'      => sprintf( esc_attr__( 'Search %1$s', 'karzo-addons' ) , $testimonial_cat_title ),
		'all_items'         => sprintf( esc_attr__( 'All %1$s', 'karzo-addons' ) , $testimonial_cat_title ),
		'parent_item'       => sprintf( esc_attr__( 'Parent %1$s', 'karzo-addons' ) , $testimonial_cat_singular_title ),
		'parent_item_colon' => sprintf( esc_attr__( 'Parent %1$s:', 'karzo-addons' ) , $testimonial_cat_singular_title ),
		'edit_item'         => sprintf( esc_attr__( 'Edit %1$s', 'karzo-addons' ) , $testimonial_cat_singular_title ),
		'update_item'       => sprintf( esc_attr__( 'Update %1$s', 'karzo-addons' ) , $testimonial_cat_singular_title ),
		'add_new_item'      => sprintf( esc_attr__( 'Add New %1$s', 'karzo-addons' ) , $testimonial_cat_singular_title ),
		'new_item_name'     => sprintf( esc_attr__( 'New %1$s Name', 'karzo-addons' ) , $testimonial_cat_singular_title ),
		'menu_name'         => $testimonial_cat_singular_title,
	);

	$testimonial_cat_args = array(
		'hierarchical'      => false,
		'public'    		=> false,
		'labels'            => $testimonial_cat_labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => esc_attr($testimonial_cat_slug) ),
	);

	register_taxonomy( 'dsvy-testimonial-cat', array( 'dsvy-testimonial' ), $testimonial_cat_args );

	/*******************************/

	// CPT - Clients
	$clients_labels = array(
		'name'					=> _x( 'Clients', 'post type general name', 'karzo-addons' ),
		'singular_name'			=> _x( 'Client', 'post type singular name', 'karzo-addons' ),
		'add_new_item'			=> esc_attr__( 'Add New Client', 'karzo-addons' ),
		'featured_image'		=> esc_attr__( 'Client Logo', 'karzo-addons' ),
		'set_featured_image'	=> esc_attr__( 'Set Client Logo', 'karzo-addons' ),
		'remove_featured_image'	=> esc_attr__( 'Remove Client Logo', 'karzo-addons' ),
		'use_featured_image'	=> esc_attr__( 'Use as Client Logo', 'karzo-addons' ),
	);

	$clients_args = array(
		'labels'             => $clients_labels,
		'menu_icon'			=> 'dashicons-grid-view',
		'public'             => false,
		'publicly_queryable' => false,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'client' ),  // important
		'capability_type'    => 'post',
		'has_archive'        => false,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'thumbnail' )
	);

	register_post_type( 'dsvy-client', $clients_args );

	/*******************************/
	// Add new taxonomy, make it hierarchical (like categories)
	$client_group_labels = array(
		'name'              => _x( 'Client Groups', 'Client Group general name', 'karzo-addons' ),
		'singular_name'     => _x( 'Client Group', 'Client Group singular name', 'karzo-addons' ),
		'search_items'      => __( 'Search Client Groups', 'karzo-addons' ),
		'all_items'         => __( 'All Client Groups', 'karzo-addons' ),
		'parent_item'       => __( 'Parent Client Group', 'karzo-addons' ),
		'parent_item_colon' => __( 'Parent Client Group:', 'karzo-addons' ),
		'edit_item'         => __( 'Edit Client Group', 'karzo-addons' ),
		'update_item'       => __( 'Update Client Group', 'karzo-addons' ),
		'add_new_item'      => __( 'Add New Client Group', 'karzo-addons' ),
		'new_item_name'     => __( 'New Client Group Name', 'karzo-addons' ),
		'menu_name'         => __( 'Client Group', 'karzo-addons' ),
	);

	$client_group_args = array(
		'hierarchical'      => false,
		'public'			=> false,
		'labels'            => $client_group_labels,
		'show_ui'           => true,
		'show_admin_column' => true,
		'query_var'         => true,
		'rewrite'           => array( 'slug' => 'dsvy-client-group' ),
	);

	register_taxonomy( 'dsvy-client-group', array( 'dsvy-client' ), $client_group_args );

	// Move feature image box below title
	add_action('do_meta_boxes', 'designervily_client_image_box');
	function designervily_client_image_box() {
		remove_meta_box( 'postimagediv', 'dsvy-client', 'side' );
		add_meta_box('postimagediv', esc_attr__('Select Client Logo', 'karzo-addons'), 'post_thumbnail_meta_box', 'dsvy-client', 'normal', 'high');
	}

	/**************************/

	// Show featured image column
	add_filter( 'manage_posts_columns', 'designervily_addon_set_featured_image_column' );
	add_action( 'manage_posts_custom_column' , 'designervily_addon_set_featured_image_column_thumbnails', 10, 2 );
	if ( ! function_exists( 'designervily_addon_set_featured_image_column' ) ) {
	function designervily_addon_set_featured_image_column( $columns ) {
		$new_columns = array();
		foreach( $columns as $key=>$val ){
			$new_columns[$key] = $val;
			if( $key=='title' ){
				$new_columns['designervily_featured_image'] = esc_attr__( 'Featured Image', 'karzo-addons' );
			}
		}
		return $new_columns;
	}
	}
	if ( ! function_exists( 'designervily_addon_set_featured_image_column_thumbnails' ) ) {
	function designervily_addon_set_featured_image_column_thumbnails( $column, $post_id ) {
		if( $column == 'designervily_featured_image' ){
			echo '<a href="'. get_permalink($post_id) .'">';
			if ( has_post_thumbnail($post_id) ) {
				the_post_thumbnail('thumbnail');
			} else {
				echo '<img src="' . KARZO_ADDON_URL . 'images/no-img-150x150.png" />';
			}
			echo '</a>';
		}

	}
	}

	// Change title input placeholder
	if( !function_exists('designervily_change_title_text') ){
	function designervily_change_title_text( $title ){
		$screen = get_current_screen();

		$team_cpt_singular_title		= esc_attr__('Team Member','karzo-addons');
		if( class_exists('Kirki') ){

			$team_cpt_singular_title2	= Kirki::get_option( 'team-cpt-singular-title' );
			$team_cpt_singular_title	= ( !empty($team_cpt_singular_title2) ) ? $team_cpt_singular_title2 : $team_cpt_singular_title ;
		}

		if( 'dsvy-testimonial' == $screen->post_type ){
			$title = esc_attr__('Enter writer name here', 'karzo-addons');
		} else if( 'dsvy-team-member' == $screen->post_type ){
			$title = sprintf( esc_attr__('Enter %1$s name here', 'karzo-addons') , $team_cpt_singular_title );
		} else if( 'dsvy-client' == $screen->post_type ){
			$title = esc_attr__('Enter Client/Company name here', 'karzo-addons');
		}
		return $title;
	}
	}
	add_filter( 'enter_title_here', 'designervily_change_title_text' );

}
}
add_action( 'init', 'karzo_addons_register_post_types', 1 );

// All widgets
include( KARZO_ADDON_PATH . 'widgets/list-all-posts-widget.php' );
include( KARZO_ADDON_PATH . 'widgets/category-list-widget.php' );
include( KARZO_ADDON_PATH . 'widgets/recent-post-widget.php' );
include( KARZO_ADDON_PATH . 'widgets/contact-widget.php' );

/**
 *  add Global Color class style
 */
add_action( 'admin_head', 'designervily_admin_globalcolor_css' );
if( !function_exists('designervily_admin_globalcolor_css') ){
function designervily_admin_globalcolor_css(){

	$white_color = '';
	if( function_exists('dsvy_get_base_option') ){
		$white_color = dsvy_get_base_option('white-color');
	}

	$blackish_color = '';
	if( function_exists('dsvy_get_base_option') ){
		$blackish_color = dsvy_get_base_option('blackish-color');
	}

	$light_bg_color = '';
	if( function_exists('dsvy_get_base_option') ){
		$light_bg_color = dsvy_get_base_option('light-bg-color');
	}

	$blackish_bg_color = '';
	if( function_exists('dsvy_get_base_option') ){
		$blackish_bg_color = dsvy_get_base_option('blackish-bg-color');
	}

	$global_color = '#ffff00';
	if( function_exists('dsvy_get_base_option') ){
		$global_color = dsvy_get_base_option('global-color');
	}

	$secondary_color = '#ffff00';
	if( function_exists('dsvy_get_base_option') ){
		$secondary_color = dsvy_get_base_option('secondary-color');
	}

	$gradient_first = '#ffff00';
	$gradient_last  = '#ffff00';
	if( function_exists('dsvy_get_base_option') ){
		$gradient_colors = dsvy_get_base_option('gradient-color');
		$gradient_first = ( !empty($gradient_colors['first']) ) ? $gradient_colors['first'] : '#ffff00' ;
		$gradient_last = ( !empty($gradient_colors['last']) ) ? $gradient_colors['last'] : '#ffff00' ;
	}

	?>
	<style>
		/* all button hover */
		.composer-switch a:hover{
			background-color: <?php echo dsvy_color_luminance($global_color, '-0.50'); ?> !important;
		}
		.dsvy-tab-main {
			font-weight: bold !important;
		}
		.dsvy-imgselector-thumb-white img{
			background-color: <?php echo esc_attr($white_color); ?> !important;
		}
		.dsvy-imgselector-thumb-blackish img{
			background-color: <?php echo esc_attr($blackish_color); ?> !important;
		}
		div.dsvy-imgselector-thumb-light[data-selector="dsvy-bg-color"] img{
			background-color: <?php echo esc_attr($light_bg_color); ?> !important;
		}
		div.dsvy-imgselector-thumb-blackish[data-selector="dsvy-bg-color"] img{
			background-color: <?php echo esc_attr($blackish_bg_color); ?> !important;
		}

		.dsvy-imgselector-thumb-globalcolor img{
			background-color: <?php echo esc_attr($global_color); ?> !important;
		}
		.dsvy-imgselector-thumb-secondarycolor img{
			background-color: <?php echo esc_attr($secondary_color); ?> !important;
		}
		.dsvy-imgselector-thumb-gradientcolor img{
			background-image: linear-gradient(to right, <?php echo esc_attr($gradient_first); ?> , <?php echo esc_attr($gradient_last); ?> );
		}
		/* dsvy Customize menu */
		.dsvy-admin-customize-menu,
		.dsvy-admin-customize-menu a:active,
		.dsvy-admin-customize-menu a:hover,
		.dsvy-admin-customize-menu a:visited,
		#adminmenu li.dsvy-admin-customize-menu>a.menu-top:focus,
		#adminmenu li.dsvy-admin-customize-menu.menu-top:hover,
		#adminmenu li.dsvy-admin-customize-menu.opensub>a.menu-top{
			background-color: <?php echo esc_attr($global_color); ?> !important;
			color: #fff !important;
			text-shadow: 0 0 #fff !important;
		}
		.dsvy-admin-customize-menu div.wp-menu-image.dashicons-before{
			font-family: dashicons;
			display: inline-block;
			line-height: 1;
			font-weight: 400;
			font-style: normal;
			speak: none;
			text-decoration: inherit;
			text-transform: none;
			text-rendering: auto;
			-webkit-font-smoothing: antialiased;
			-moz-osx-font-smoothing: grayscale;
			width: 20px;
			height: 20px;
			font-size: 20px;
			vertical-align: top;
			text-align: center;
			transition: color .1s ease-in;
			font-size: 240px;
			width: 240px;
			height: 240px;
			overflow: visible;
		}
		#adminmenu li.dsvy-admin-customize-menu a:focus div.wp-menu-image:before,
		#adminmenu li.dsvy-admin-customize-menu.opensub div.wp-menu-image:before,
		#adminmenu li.dsvy-admin-customize-menu:hover div.wp-menu-image:before{
			color: #fff !important;
		}
		.dsvy-admin-customize-menu div.wp-menu-image.dashicons-before:before{
			content: "\f139";
		}
	</style>
	<script>
	jQuery( document ).ready(function($) {
		$( "button:contains('KARZO ELEMENTS')" ).addClass('dsvy-tab-main');
	});
	</script>

	<?php

}
}

/**
 * This function adds some styles to the WordPress Customizer
 */
if( !function_exists('designervily_customizer_styles') ){
function designervily_customizer_styles() {

	$global_color = '#ffff00';
	if( function_exists('dsvy_get_base_option') ){
		$global_color = dsvy_get_base_option('global-color');
	}
	$secondary_color = '#ffff00';
	if( function_exists('dsvy_get_base_option') ){
		$secondary_color = dsvy_get_base_option('secondary-color');
	}

	$gradient_first = '#ffff00';
	$gradient_last  = '#ffff00';
	if( function_exists('dsvy_get_base_option') ){
		$gradient_colors = dsvy_get_base_option('gradient-color');
		$gradient_first = ( !empty($gradient_colors['first']) ) ? $gradient_colors['first'] : '#ffff00' ;
		$gradient_last = ( !empty($gradient_colors['last']) ) ? $gradient_colors['last'] : '#ffff00' ;
	}

	?>
	<style>
		/* Customizer option */
		#accordion-panel-karzo_base_options h3{
			background-color: <?php echo esc_attr($global_color); ?> !important;
			color: #ffffff !important;
			border-left-color: #2d2d2d !important;
		}
		#accordion-panel-karzo_base_options h3:after{
			color: #ffffff !important;
		}
		#accordion-panel-karzo_base_options:hover h3{
			border-left-color: #000000 !important;
		}
		#accordion-panel-karzo_base_options:hover h3:after{
			color: #000000 !important;
		}

		.accordion-section.control-section-kirki-default.control-subsection:hover h3,
		.accordion-section.control-section-kirki-default.control-subsection h3:focus{
			color: <?php echo esc_attr($global_color); ?> !important;
			border-left-color: <?php echo esc_attr($global_color); ?> !important;
		}
		.accordion-section.control-section-kirki-default.control-subsection:hover h3:after,
		.accordion-section.control-section-kirki-default.control-subsection h3:focus:after{
			color: <?php echo esc_attr($global_color); ?> !important;
		}

		/* Back Button */
		#sub-accordion-panel-karzo_base_options li.panel-meta .customize-panel-back{
			color: <?php echo esc_attr($global_color); ?> !important;
			border-left-color: <?php echo esc_attr($global_color); ?> !important;
		}
		ul.customize-pane-child.control-section-kirki-default .customize-section-back{
			color: <?php echo esc_attr($global_color); ?> !important;
			border-left-color: <?php echo esc_attr($global_color); ?> !important;
		}
		#sub-accordion-panel-karzo_base_options .panel-title{
			color: <?php echo esc_attr($global_color); ?> !important;
		}

		/* Customizer */
		label[class$="globalcolor"] img{
			background-color: <?php echo esc_attr($global_color); ?> !important;
		}
		label[class$="secondarycolor"] img{
			background-color: <?php echo esc_attr($secondary_color); ?> !important;
		}
		label[class$="gradientcolor"] img{
			background-color: <?php echo esc_attr($gradient_first); ?> !important;
			background-image: linear-gradient(to right, <?php echo esc_attr($gradient_first); ?> , <?php echo esc_attr($gradient_last); ?> ) !important;
			color: #ffffff !important;
		}
	</style>
	<?php
}
}
add_action( 'customize_controls_print_styles', 'designervily_customizer_styles' );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */

if( !function_exists('karzo_addons_widgets_init') ){
function karzo_addons_widgets_init() {

	// Default titles
	$portfolio_cpt_singular_title	= esc_attr__('Portfolio','karzo-addons');
	$portfolio_cat_singular_title	= esc_attr__('Portfolio Category','karzo-addons');
	$service_cpt_singular_title		= esc_attr__('Service','karzo-addons');
	$service_cat_singular_title		= esc_attr__('Service Category','karzo-addons');
	$team_cpt_singular_title		= esc_attr__('Team Member','karzo-addons');
	$team_group_singular_title		= esc_attr__('Team Group','karzo-addons');

	if( function_exists('dsvy_get_base_option') ){

		// Portfolio - singular
		$portfolio_cpt_singular_title2	= dsvy_get_base_option( 'portfolio-cpt-singular-title' );
		$portfolio_cpt_singular_title	= ( !empty($portfolio_cpt_singular_title2) ) ? $portfolio_cpt_singular_title2 : $portfolio_cpt_singular_title ;

		// Portfolio Category - singular
		$portfolio_cat_singular_title2	= dsvy_get_base_option( 'portfolio-cat-singular-title' );
		$portfolio_cat_singular_title	= ( !empty($portfolio_cat_singular_title2) ) ? $portfolio_cat_singular_title2 : $portfolio_cat_singular_title ;

		// Service - singular
		$service_cpt_singular_title2	= dsvy_get_base_option( 'service-cpt-singular-title' );
		$service_cpt_singular_title	= ( !empty($service_cpt_singular_title2) ) ? $service_cpt_singular_title2 : $service_cpt_singular_title ;

		// Portfolio Category - singular
		$service_cat_singular_title2	= dsvy_get_base_option( 'service-cat-singular-title' );
		$service_cat_singular_title	= ( !empty($service_cat_singular_title2) ) ? $service_cat_singular_title2 : $service_cat_singular_title ;

		// Team - singular
		$team_cpt_singular_title2	= dsvy_get_base_option( 'team-cpt-singular-title' );
		$team_cpt_singular_title	= ( !empty($team_cpt_singular_title2) ) ? $team_cpt_singular_title2 : $team_cpt_singular_title ;

		// Team Group - singular
		$team_group_singular_title2	= dsvy_get_base_option( 'team-group-singular-title' );
		$team_group_singular_title	= ( !empty($team_group_singular_title2) ) ? $team_group_singular_title2 : $team_group_singular_title ;

	}

	register_sidebar( array(
		'name'          => sprintf( esc_attr__( '%1$s Sidebar', 'karzo-addons' ) , $portfolio_cpt_singular_title ),
		'id'            => 'dsvy-sidebar-portfolio',
		'description'   => sprintf( esc_attr__( 'Add widgets for %1$s Sidebar', 'karzo-addons' ) , $portfolio_cpt_singular_title ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => sprintf( esc_attr__( '%1$s Sidebar', 'karzo-addons' ) , $portfolio_cat_singular_title ),
		'id'            => 'dsvy-sidebar-portfolio-cat',
		'description'   => sprintf( esc_attr__( 'Add widgets for %1$s Sidebar', 'karzo-addons' ) , $portfolio_cat_singular_title ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => sprintf( esc_attr__( '%1$s Sidebar', 'karzo-addons' ) , $service_cpt_singular_title ),
		'id'            => 'dsvy-sidebar-service',
		'description'   => sprintf( esc_attr__( 'Add widgets for %1$s Sidebar', 'karzo-addons' ) , $service_cpt_singular_title ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => sprintf( esc_attr__( '%1$s Sidebar', 'karzo-addons' ) , $service_cat_singular_title ),
		'id'            => 'dsvy-sidebar-service-cat',
		'description'   => sprintf( esc_attr__( 'Add widgets for %1$s Sidebar', 'karzo-addons' ) , $service_cat_singular_title ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => __( 'Team Member Sidebar', 'karzo-addons' ),
		'name'          => sprintf( esc_attr__( '%1$s Sidebar', 'karzo-addons' ) , $team_cpt_singular_title ),
		'id'            => 'dsvy-sidebar-team',
		'description'   => sprintf( esc_attr__( 'Add widgets for %1$s Sidebar', 'karzo-addons' ) , $team_cpt_singular_title ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => sprintf( esc_attr__( '%1$s Sidebar', 'karzo-addons' ) , $team_group_singular_title ),
		'id'            => 'dsvy-sidebar-team-group',
		'description'   => sprintf( esc_attr__( 'Add widgets for %1$s Sidebar', 'karzo-addons' ) , $team_group_singular_title ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	if( function_exists('is_woocommerce') ){
		register_sidebar( array(
			'name'			=> esc_html__( 'WooCommerce - Shop Page', 'karzo-addons' ),
			'id'			=> 'dsvy-sidebar-wc-shop',
			'description'	=> esc_html__( 'Widgets for WooCommerce shop (product listing) page.', 'karzo-addons' ),
			'before_widget'	=> '<aside id="%1$s" class="widget %2$s">',
			'after_widget'	=> '</aside>',
			'before_title'	=> '<h3 class="widget-title">',
			'after_title'	=> '</h3>',
		) );
		register_sidebar( array(
			'name'			=> esc_html__( 'WooCommerce - Single Product Page', 'karzo-addons' ),
			'id'			=> 'dsvy-sidebar-wc-single',
			'description'	=> esc_html__( 'Widgets for WooCommerce single product page.', 'karzo-addons' ),
			'before_widget'	=> '<aside id="%1$s" class="widget %2$s">',
			'after_widget'	=> '</aside>',
			'before_title'	=> '<h3 class="widget-title">',
			'after_title'	=> '</h3>',
		) );
	}

	if( class_exists('WP_Event_Manager') ){
		register_sidebar( array(
			'name'			=> esc_html__( 'Events - Event Section Slidebar', 'karzo-addons' ),
			'id'			=> 'dsvy-sidebar-event',
			'description'	=> esc_html__( 'Widgets for Event secion pages.', 'karzo-addons' ),
			'before_widget'	=> '<aside id="%1$s" class="widget %2$s">',
			'after_widget'	=> '</aside>',
			'before_title'	=> '<h3 class="widget-title">',
			'after_title'	=> '</h3>',
		) );
		register_sidebar( array(
			'name'			=> esc_html__( 'Events - Single Event Slidebar', 'karzo-addons' ),
			'id'			=> 'dsvy-sidebar-event-single',
			'description'	=> esc_html__( 'Widgets for Event single page.', 'karzo-addons' ),
			'before_widget'	=> '<aside id="%1$s" class="widget %2$s">',
			'after_widget'	=> '</aside>',
			'before_title'	=> '<h3 class="widget-title">',
			'after_title'	=> '</h3>',
		) );
	}


}
}
add_action( 'widgets_init', 'karzo_addons_widgets_init', 21 );

/**
 * Enqueue scripts and styles.
 */
if( !function_exists('karzo_addons_admin_scripts_styles') ){
function karzo_addons_admin_scripts_styles() {
	wp_enqueue_style( 'balloon', KARZO_ADDON_URL . 'libraries/balloon/balloon.min.css' );
}
}
add_action( 'admin_enqueue_scripts', 'karzo_addons_admin_scripts_styles' );

if ( ! function_exists( 'dsvy_edit_link' ) ) :
/**
 * Returns an accessibility-friendly link to edit a post or page.
 *
 * This also gives us a little context about what exactly we're editing
 * (post or page?) so that users understand a bit more where they are in terms
 * of the template hierarchy and their content. Helpful when/if the single-page
 * layout with multiple posts/pages shown gets confusing.
 */
function dsvy_edit_link() {
	edit_post_link(
		sprintf(
			/* translators: %s: Name of current post */
			__( 'Edit<span class="screen-reader-text"> "%s"</span>', 'karzo-addons' ),
			get_the_title()
		),
		'<span class="edit-link">',
		'</span>'
	);
}
endif;

if( !function_exists('dsvy_get_base_options') ) {
function dsvy_get_base_options( $option='' ){
	$return = '';

	if( class_exists('Kirki') ){
		$return = Kirki::get_option( $option );
	} else {
		if( !$kirki_options_array ){
			include get_template_directory() . '/includes/customizer-options.php';
		}
		foreach( $kirki_options_array as $kirki_options ){
			if( !empty($kirki_options['section_fields']) ){
				foreach( $kirki_options['section_fields'] as $field ){
					if( !empty($field['settings']) && $field['settings']==$option && isset($field['default']) ){
						$return = $field['default'];
					}
				}
			}
		}
	}

	return $return;
}
}

/**
 *  Add CSS / JS / Tracking code in head
 */
if( !function_exists('designervily_custom_code') ){
function designervily_custom_code(){
	$tracking_code	= dsvy_get_base_option('tracking-code');
	$css_code		= dsvy_get_base_option('css-code');
	$css_code		= htmlspecialchars_decode($css_code);
	$css_code		= html_entity_decode($css_code, ENT_QUOTES);

	$js_code		= dsvy_get_base_option('js-code');
	$js_code		= htmlspecialchars_decode($js_code);
	$js_code		= html_entity_decode($js_code, ENT_QUOTES);

	// Tracking code
	echo $tracking_code;

	// CSS Code
	if( !empty($css_code) ){
		echo '<style>'.$css_code.'</style>';
	}

	// JS Code
	if( !empty($js_code) ){
		echo '<script>'.$js_code.'</script>';
	}

}
}
add_action( 'wp_head', 'designervily_custom_code' );

// CSS Minifier => http://ideone.com/Q5USEF + improvement(s)
if( !function_exists('dsvy_minify_css') ){
function dsvy_minify_css($input) {
    if(trim($input) === "") return $input;
    return preg_replace(
        array(
            // Remove comment(s)
            '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')|\/\*(?!\!)(?>.*?\*\/)|^\s*|\s*$#s',
            // Remove unused white-space(s)
            '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\'|\/\*(?>.*?\*\/))|\s*+;\s*+(})\s*+|\s*+([*$~^|]?+=|[{};,>~+]|\s*+-(?![0-9\.])|!important\b)\s*+|([[(:])\s++|\s++([])])|\s++(:)\s*+(?!(?>[^{}"\']++|"(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')*+{)|^\s++|\s++\z|(\s)\s+#si',
            // Replace `0(cm|em|ex|in|mm|pc|pt|px|vh|vw|%)` with `0`
            '#(?<=[\s:])(0)(cm|em|ex|in|mm|pc|pt|px|vh|vw|%)#si',
            // Replace `:0 0 0 0` with `:0`
            '#:(0\s+0|0\s+0\s+0\s+0)(?=[;\}]|\!important)#i',
            // Replace `background-position:0` with `background-position:0 0`
            '#(background-position):0(?=[;\}])#si',
            // Replace `0.6` with `.6`, but only when preceded by `:`, `,`, `-` or a white-space
            '#(?<=[\s:,\-])0+\.(\d+)#s',
            // Minify string value
            '#(\/\*(?>.*?\*\/))|(?<!content\:)([\'"])([a-z_][a-z0-9\-_]*?)\2(?=[\s\{\}\];,])#si',
            '#(\/\*(?>.*?\*\/))|(\burl\()([\'"])([^\s]+?)\3(\))#si',
            // Minify HEX color code
            '#(?<=[\s:,\-]\#)([a-f0-6]+)\1([a-f0-6]+)\2([a-f0-6]+)\3#i',
            // Replace `(border|outline):none` with `(border|outline):0`
            '#(?<=[\{;])(border|outline):none(?=[;\}\!])#',
            // Remove empty selector(s)
            '#(\/\*(?>.*?\*\/))|(^|[\{\}])(?:[^\s\{\}]+)\{\}#s'
        ),
        array(
            '$1',
            '$1$2$3$4$5$6$7',
            '$1',
            ':0',
            '$1:0 0',
            '.$1',
            '$1$3',
            '$1$2$4$5',
            '$1$2$3',
            '$1:0',
            '$1$2'
        ),
    $input);
}
}

// JavaScript Minifier
if( !function_exists('dsvy_minify_js') ){
function dsvy_minify_js($input) {
    if(trim($input) === "") return $input;
    return preg_replace(
        array(
            // Remove comment(s)
            '#\s*("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')\s*|\s*\/\*(?!\!|@cc_on)(?>[\s\S]*?\*\/)\s*|\s*(?<![\:\=])\/\/.*(?=[\n\r]|$)|^\s*|\s*$#',
            // Remove white-space(s) outside the string and regex
            '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\'|\/\*(?>.*?\*\/)|\/(?!\/)[^\n\r]*?\/(?=[\s.,;]|[gimuy]|$))|\s*([!%&*\(\)\-=+\[\]\{\}|;:,.<>?\/])\s*#s',
            // Remove the last semicolon
            '#;+\}#',
            // Minify object attribute(s) except JSON attribute(s). From `{'foo':'bar'}` to `{foo:'bar'}`
            '#([\{,])([\'])(\d+|[a-z_][a-z0-9_]*)\2(?=\:)#i',
            // --ibid. From `foo['bar']` to `foo.bar`
            '#([a-z0-9_\)\]])\[([\'"])([a-z_][a-z0-9_]*)\2\]#i'
        ),
        array(
            '$1',
            '$1$2',
            '}',
            '$1$3',
            '$1.$3'
        ),
    $input);
}
}

if( !function_exists('dsvy_after_import') ){
function dsvy_after_import( $selected_import ) {
	// Assign menus to their locations.
	$main_menu = get_term_by( 'name', esc_attr('Main Menu'), 'nav_menu' );
	set_theme_mod(
		'nav_menu_locations', array(
			'designervily-top' => $main_menu->term_id,
		)
	);
	// Assign front page and posts page (blog page).
	$query = new WP_Query( array( 'post_type' => 'page', 'title' => 'Home 01' ) );
	if ( ! empty( $query->post ) ) {
		$front_page_id 	= $query->post;
		if( isset($front_page_id->ID) && !empty($front_page_id->ID) ){
			update_option( 'page_on_front', $front_page_id->ID );
			update_option( 'show_on_front', 'page' );
		}
	}
	$query = new WP_Query( array( 'post_type' => 'page', 'title' => 'Blog Classic' ) );
	if ( ! empty( $query->post ) ) {
		$blog_page_id  	= $query->post;
		if( isset($blog_page_id ->ID) && !empty($blog_page_id ->ID) ){
			update_option( 'page_for_posts', $blog_page_id->ID );
			update_option( 'show_on_front', 'page' );
		}
	}

	// Changing "Hello World" post date
	$query = new WP_Query( array( 'title' => 'Hello world!', OBJECT, 'post_type' => 'post' ) );
	if ( ! empty( $query->post ) ) {
		$hello_world_post  	= $query->post;
		if( isset($hello_world_post ->ID) && !empty($hello_world_post ->ID) ){
			$hw_post = array(
			'ID'		=> $hello_world_post->ID,
			'post_date'	=> "2010-01-01 0:0:0" // Format : Y-m-d H:i:s
		);
			wp_update_post($hw_post);
		}
	}

}
}
add_action( 'theme-demo-import/after_import', 'dsvy_after_import' );

/**
 *  Dynamic Style Code
 */
if( !function_exists('dsvy_auto_css') ){
function dsvy_auto_css() {
	header("Content-Type: text/css");
	ob_start();
	include get_template_directory().'/css/theme-style.php'; // Fetching theme-style.php output and store in a variable
	$css    = ob_get_clean();

	// Minify
	if( defined('WP_DEBUG') && true === WP_DEBUG ){
		echo $css;
	} else {
		if( function_exists('dsvy_minify_css') ){
			echo dsvy_minify_css( $css );
		} else {
			echo $css;
		}
	}
	exit;
}
}
add_action('wp_ajax_dsvy_auto_css', 'dsvy_auto_css');
add_action('wp_ajax_nopriv_dsvy_auto_css', 'dsvy_auto_css');

if( !function_exists('dsvy_get_column_bg') ){
function dsvy_get_column_bg( $content='', $type='first' ) {
	$class = $inline_css = $bg_img = '';

	preg_match_all('/' . get_shortcode_regex() . '/s', $content, $matches, PREG_SET_ORDER);
	$total_columns = count($matches);

	if( $type=='first' ){
		$match = $matches[0];
		$atts  = shortcode_parse_atts( $match[3] );

	} else if( $type=='last' ){
		$match = $matches[ count($matches)-1 ];
		$atts  = shortcode_parse_atts( $match[3] );
	}

	// background color class
	if( !empty($atts['dsvy-bg-color']) ){
		$class = 'dsvy-bg-color-' . $atts["dsvy-bg-color"];
	}

	// custom background
	if( !empty($atts['css']) ){
		$css = $atts['css'];

		$css2 = explode('{', $css );
		$css2 = explode('}', $css2[1] );
		$css2 = explode(';', $css2[0] );
		$x = 1;
		foreach( $css2 as $css ){

			if( substr( $css,0, 11 )=='background:' || substr( $css,0, 17 )=='background-image:' ){
				$inline_css .= $css.';';

				// Getting background image
				if( substr( $css,0, 11 )=='background:' ){
					$bg_img2 = explode('background:', $css );
					$bg_img2 = explode('url(', $bg_img2[1] );
					$bg_img2 = $bg_img2[1];
					$bg_img2 = str_replace( ') !important', '', $bg_img2 );

				} else if( substr( $css,0, 17 )=='background-image:' ){
					$bg_img2 = explode('background-image:', $css );
					$bg_img2 = explode('url(', $bg_img2[1] );
					$bg_img2 = $bg_img2[1];
					$bg_img2 = str_replace( ') !important', '', $bg_img2 );

				}

				$bg_img = $bg_img2;

			} else if( substr( $css,0, 17 )=='background-color:' ){
				$inline_css .= $css.';';

			} else if( substr( $css,0, 16 )=='background-size:' ){
				$inline_css .= $css.';';

			} else if( substr( $css,0, 12 )=='margin-left:' ){
				$inline_css .= $css.';';

			} else if( substr( $css,0, 11 )=='margin-top:' ){
				$inline_css .= $css.';';

			} else if( substr( $css,0, 13 )=='margin-right:' ){
				$inline_css .= $css.';';

			} else if( substr( $css,0, 14 )=='margin-bottom:' ){
				$inline_css .= $css.';';

			}
		}
	}

	return array(
		'class'			=> $class,
		'inline_css'	=> $inline_css,
		'bg_img'		=> $bg_img,
	);
}
}

if( !function_exists('dsvy_bg_from_css') ){
	function dsvy_bg_from_css( $css='', $type='inlinestyle' ) {
		$class = $inline_css = $bg_img = '';

		// custom background
		if( !empty($css) ){

			$css2 = explode('{', $css );
			$css2 = explode('}', $css2[1] );
			$css2 = explode(';', $css2[0] );
			$x = 1;
			foreach( $css2 as $css ){

				if( substr( $css,0, 11 )=='background:' || substr( $css,0, 17 )=='background-image:' ){
					$inline_css .= $css.';';

					// Getting background image
					if( substr( $css,0, 11 )=='background:' ){
						$bg_img2 = explode('background:', $css );
						$bg_img2 = explode('url(', $bg_img2[1] );
						$bg_img2 = $bg_img2[1];
						$bg_img2 = str_replace( ') !important', '', $bg_img2 );

					} else if( substr( $css,0, 17 )=='background-image:' ){
						$bg_img2 = explode('background-image:', $css );
						$bg_img2 = explode('url(', $bg_img2[1] );
						$bg_img2 = $bg_img2[1];
						$bg_img2 = str_replace( ') !important', '', $bg_img2 );

					}

					$bg_img = $bg_img2;

				} else if( substr( $css,0, 17 )=='background-color:' ){
					$inline_css .= $css.';';

				} else if( substr( $css,0, 16 )=='background-size:' ){
					$inline_css .= $css.';';
				}
			}
		}

		if( $type=='inlinestyle' ){
			return $inline_css;
		}

	}
	}

if( !function_exists('dsvy_uencode') ){
function dsvy_uencode( $input ){
	return urlencode($input);
}
}

if( !function_exists('dsvy_karzo_addons_woocommerce_init') ){
function dsvy_karzo_addons_woocommerce_init(){

	remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);

	// First remove default wrapper
	remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
	remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);

	// Then add new wrappers
	add_action('woocommerce_before_main_content', 'dsvy_wc_content_wrapper_start', 10);
	add_action('woocommerce_after_main_content', 'dsvy_wc_content_wrapper_end', 10);

	if( !function_exists('dsvy_wc_content_wrapper_start') ){
	function dsvy_wc_content_wrapper_start() {
		?>
		<div id="primary" class="content-area <?php if( dsvy_check_sidebar() ) { ?>col-md-9 col-lg-9<?php } ?>">
		<?php
	}
	}

	if( !function_exists('dsvy_wc_content_wrapper_end') ){
	function dsvy_wc_content_wrapper_end() {
		?>
		</div>
		<?php
	}
	}

}
}
add_action( 'init', 'dsvy_karzo_addons_woocommerce_init' );

add_filter( 'woocommerce_output_related_products_args', 'dsvy_related_products_args', 20 );
function dsvy_related_products_args( $args ) {
	$show = 4;
	if( function_exists('dsvy_get_base_option') ){
		$show = dsvy_get_base_option('wc-related-count');
	}
	$args['posts_per_page']	= $show;
	$args['columns']		= $show;
	return $args;
}

add_action( 'woocommerce_before_shop_loop_item_title', 'dsvy_show_yith_wishlist_btn', 20, 0 );
function dsvy_show_yith_wishlist_btn(){
	if( shortcode_exists('yith_wcwl_add_to_wishlist') ){
		echo do_shortcode('[yith_wcwl_add_to_wishlist]');
	}
}

if( !function_exists('dsvy_revslider_template_check') ){
function dsvy_revslider_template_check() {
	update_option('revslider-templates-check', time());
	update_option('kirki_telemetry_no_consent', '1');
}
}
register_activation_hook( __FILE__ , 'dsvy_revslider_template_check' );

/**
 * Change loader image on preview
 */
if( !function_exists('dsvy_set_preview_loader') ){
function dsvy_set_preview_loader(){
	if( function_exists('dsvy_get_base_option') && function_exists('is_customize_preview') ){
		if( is_customize_preview() ){
			echo '<style> body .kirki-customizer-loading-wrapper{background-image: none !important;}</style>';
		}
	}
}
}
add_action( 'wp_footer', 'dsvy_set_preview_loader');

if( !function_exists('dsvy_karzo_addons_tgmpa_message') ){
function dsvy_karzo_addons_tgmpa_message(){
	// Enable TGMPA update message
	$theme_name				= get_template();
	$theme_data				= wp_get_theme( $theme_name );
	$theme_version			= $theme_data->get( 'Version' );
	$stored_theme_version	= get_option('dsvy_karzo_version');
	$user_id				= get_current_user_id();
	if( $theme_name == 'karzo' && $theme_version != $stored_theme_version ){
		delete_user_meta( $user_id, 'tgmpa_dismissed_notice_tgmpa' );
		delete_user_meta( $user_id, 'tgmpa_dismissed_notice_karzo' );
		update_option( 'dsvy_karzo_version', $theme_version );
	}
}
}
add_action( 'admin_init', 'dsvy_karzo_addons_tgmpa_message', 1 );


/**
 * Login Page CSS code
 */
if( !function_exists('dsvy_karzo_addons_login_page_css') ){
function dsvy_karzo_addons_login_page_css(){
	// Login Logo
	$main_logo			= dsvy_get_base_option('logo');
	$show_custom_logo	= dsvy_get_base_option('custom-login-logo');
	if( $show_custom_logo == '1' ){
		$login_logo = dsvy_get_base_option('login-logo');
		$main_logo  = (!empty($login_logo)) ? $login_logo : $main_logo ;
	}

	// Login background
	$bg_css = '';
	$bg = dsvy_get_base_option( 'login-page-background' );
	if( is_array($bg) && count($bg)>0 ){
		foreach( $bg as $key=>$val ){
			if( $key=='background-image' ){ $val = 'url('.$val.')'; }
			$bg_css .= $key.':'.$val.';'."\n";
		}
	}
	// Global colors
	$global_color = dsvy_get_base_option( 'global-color' );
	?>
	<style type="text/css">
		<?php if( !empty($main_logo) ){ ?>
		#login h1 a, .login h1 a {
			background-image: url(<?php echo esc_url($main_logo); ?>);
			background-size: contain;
			background-position: center center;
			background-repeat: no-repeat;
			height: 100px;
			width: 214px;
		}
		<?php } ?>
		.clear,
		.clr,
		.clearfix{
			clear: both;
		}
		body.login{
			<?php echo $bg_css; ?>
			height: auto;
		}
		body.login a,
		body.login #backtoblog a,
		body.login #nav a{
			color: #000;
			transition: all 0.4s, all 0.4s;
		}
		body.login a:hover,
		body.login #backtoblog a:hover,
		body.login #nav a:hover{
			color: <?php echo $global_color; ?>;
		}
		body.login #backtoblog a:focus,
		body.login #nav a:focus,
		body.login h1 a:focus,
		body.login.wp-core-ui .button-primary.focus,
		body.login.wp-core-ui .button-primary:focus{
			box-shadow: none;
		}
		body.login #wp-submit{
			background-color: <?php echo $global_color; ?>;
			border-color: <?php echo $global_color; ?>;
			transition: all 0.4s, all 0.4s;
		}
		body.login #wp-submit:hover{
			background-color:#000;
			border-color:#000;
		}
		body.login #login{
			background: #fff;
			padding: 40px;
			margin-top: 60px;
			box-shadow: 0 0 20px 0px rgb(0 0 0 / 26%);
		}
		body.login #login form{
			background-color: transparent;
			border: none;
			border-radius: 0;
			box-shadow: none;
			padding: 0;
		}
		body.login form .input {
			border: 1px solid #ccc;
			border-radius: 0;
			transition: all 0.4s, all 0.4s;
			box-shadow: none;
			outline: none;
		}
		body.login form .input:focus {
			border: 1px solid <?php echo $global_color; ?>;
			box-shadow: none;
			
		}
		body.login #login form label{
			font-weight: bold;
		}
		body.login #backtoblog,
		body.login #nav {
			padding: 0;
		}
		body.login .dsvy-login-bottom-links{
			padding-top: 35px;
		}
		body.login .dsvy-login-bottom-links #nav{
			float: left;
			margin-top: 0;
			font-weight: bold;
		}
		body.login .dsvy-login-bottom-links #backtoblog{
			float: right;
			margin-top: 0;
			font-weight: bold;
		}
		body.login #login_error,
		body.login .message, .login .success{
			box-shadow: 1px 1px 3px 0px rgb(0 0 0 / 22%);
		}
		body.login .button.wp-hide-pw{
			color: <?php echo $global_color; ?>;
		}
		body.login .button.wp-hide-pw:focus{
			border: none;
			box-shadow: none;
		}
		body.login input[type=checkbox],
		body.login input[type=checkbox]:focus{
			border-radius: inherit;
			box-shadow: none;
		}
	</style>
	<script type="text/javascript">
		jQuery(document).ready(function(){
			jQuery("#nav").insertAfter("p.submit");
			jQuery("#backtoblog").insertAfter("#nav");
			jQuery( "#nav, #backtoblog" ).wrapAll( '<div class="dsvy-login-bottom-links"></div>' );
			jQuery('<div class="clear clr clearfix"></div>').insertAfter("p.submit");
			jQuery('<div class="clear clr clearfix"></div>').insertAfter("#backtoblog");
		});
	</script>

<?php
}
}
add_action( 'login_footer', 'dsvy_karzo_addons_login_page_css' );

if( !function_exists('dsvy_karzo_addons_login_scripts') ){
function dsvy_karzo_addons_login_scripts() {
	wp_enqueue_script( 'jquery' );
}
}
add_action( 'login_enqueue_scripts', 'dsvy_karzo_addons_login_scripts' );

if( !function_exists('dsvy_login_logo_url') ){
function dsvy_login_logo_url() {
	return home_url( '/' );
}
}
add_filter( 'login_headerurl', 'dsvy_login_logo_url');

if( !function_exists('dsvy_login_logo_title') ){
function dsvy_login_logo_title() {
	return get_bloginfo( 'title', 'display' );
}
}
add_filter( 'login_headertext', 'dsvy_login_logo_title');

if( !function_exists('dsvy_clear_elementor_cache') ){
function dsvy_clear_elementor_cache(){
	update_option( 'elementor_css_print_method', 'external' );
	$folder = WP_CONTENT_DIR. 'uploads/elementor/css';
	if( file_exists($folder) && is_dir($folder) ){
		foreach ( glob( $folder ) as $file_path ) {
			unlink( $file_path );
		}
	}
}
}
/**
 * Disable kirki plugin if enabled
 */

if( !function_exists('dsvy_disable_kirki_plugin') ){
function dsvy_disable_kirki_plugin(){
	$check_status = get_option('dsvy-kirki-disabled-once');
	if( $check_status != 'yes' ){
		deactivate_plugins( '/kirki/kirki.php' );
		update_option('dsvy-kirki-disabled-once', 'yes');
	}
}
}
add_action( 'admin_init', 'dsvy_disable_kirki_plugin' );
add_action( 'init', 'dsvy_disable_kirki_plugin' );