<?php

use Elementor\Icons_Manager;

// Icon
$icon_html = $icon_array = '';
$custom_icon_enabled = get_post_meta( get_the_ID(), 'dsvy-custom-icon-enabled', true );
if( $custom_icon_enabled=='1' ){
	$img_src = '';
	$custom_icon_url = get_post_meta( get_the_ID(), 'dsvy-custom-icon', true );
	if( !empty($custom_icon_url) ){
		$img_src = wp_get_attachment_image_src($custom_icon_url, 'full');
		if( !empty($img_src[0]) ){ $custom_icon_url = $img_src[0]; }
	}
	$icon_html = '<img src="'.$custom_icon_url.'"/>';
}else{
	$icon_lib = get_post_meta( get_the_ID(), 'dsvy-service-icon-library', true );
	wp_enqueue_style($icon_lib);
	$icon_class = get_post_meta( get_the_ID(), 'dsvy-service-icon-'.$icon_lib, true );

	// icon library name for the function
	$icon_lib2 = $icon_lib;
	if( $icon_lib == 'elementor-icons-fa-regular' ){
		$icon_lib2 = 'fa-regular';
	} else if( $icon_lib == 'elementor-icons-fa-solid' ){
		$icon_lib2 = 'fa-solid';
	} else if( $icon_lib == 'elementor-icons-fa-brands' ){
		$icon_lib2 = 'fa-brands';
	}
	$icon_array = array(
		'value' => $icon_class,
		'library' => $icon_lib2,
	);
}

// Read More text
if( !isset($more_text) ){
	$more_text = esc_attr__('More','karzo');
}
?>
<div class="designervily-post-item">
	<div class="dsvy-service-img-wrapper">
		<?php dsvy_get_featured_data( array( 'featured_img_only' => true, 'size' => 'dsvy-img-740x800' ) ); ?>
	</div>
	<div class="dsvy-meta">
		<div class="designervily-box-content-inner d-flex align-items-center">
			<?php if( $custom_icon_enabled=='1' ): ?>
			<div class="dsvy-service-custom-icon-wrapper">
			<?php else: ?>
			<div class="dsvy-service-icon-wrapper">
				<?php endif; ?>
				<?php if( !empty($icon_html)){
					echo dsvy_esc_kses ( $icon_html );
				} else {
					Icons_Manager::render_icon( $icon_array, [ 'aria-hidden' => 'true' ] );
				} ?>
			</div>
			<div class="dsvy-service-detail">
				<h3 class="dsvy-service-title"><a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3> 
				<div class="dsvy-service-cat"><h4><?php echo get_the_term_list( get_the_ID(), 'dsvy-service-category', '', ', ' ); ?></h4></div>
			</div>
		</div>
	</div>
	<div class="designervily-box-content">
		<div class="designervily-box-content-inner">
			<?php if( $custom_icon_enabled=='1' ): ?>
			<div class="dsvy-service-custom-icon-wrapper">
			<?php else: ?>
			<div class="dsvy-service-icon-wrapper">
				<?php endif; ?>
				<?php if( !empty($icon_html)){
					echo dsvy_esc_kses ( $icon_html );
				} else {
					Icons_Manager::render_icon( $icon_array, [ 'aria-hidden' => 'true' ] );
				} ?>
			</div>
			<h3 class="dsvy-service-title"><a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
			<div class="dsvy-service-cat"><h4><?php echo get_the_term_list( get_the_ID(), 'dsvy-service-category', '', ', ' ); ?></h4></div>
			<?php if( has_excerpt() ) : ?>
			<div class="dsvy-service-content"><?php the_excerpt(); ?></div>
		<?php endif; ?>
		</div>
	</div>
	<div class="dsvy-service-btn">
		<a class="btn-arrow" href="<?php the_permalink(); ?>"> <span class="dsvy-arrow"></span></a>
	</div>
</div>