<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Section Heading 
 */
class DSVY_TabsElement extends Widget_Base{

 	/**
	 * Get widget name.
	 *
	 * Retrieve tabs widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'dsvy_tabs_element';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve tabs widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Karzo Tabs Element', 'karzo' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve tabs widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-box';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'karzo_category' ];
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'tabs', 'accordion', 'toggle' ];
	}

	protected function register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Tabs', 'karzo' ),
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'tab_icon',
			[
				'label' => __( 'Icon', 'karzo' ),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
			]
		);

		$repeater->add_control(
			'tab_title',
			[
				'label' => __( 'Title & Description', 'karzo' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Tab Title', 'karzo' ),
				'placeholder' => __( 'Tab Title', 'karzo' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'tab_content',
			[
				'label' => __( 'Content', 'karzo' ),
				'default' => __( 'Tab Content', 'karzo' ),
				'placeholder' => __( 'Tab Content', 'karzo' ),
				'type' => Controls_Manager::WYSIWYG,
				'show_label' => false,
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => __( 'Tabs Items', 'karzo' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'tab_title' => __( 'Tab #1', 'karzo' ),
						'tab_icon' => [ 'value' => 'fas fa-star', 'library' => 'fa-solid' ],
						'tab_content' => __( 'We help ambitious businesses like yours generate more profits by building awareness, driving web traffic, connecting with customers, and growing overall sales. Give us a call.', 'karzo' ),
					],
					[
						'tab_title' => __( 'Tab #2', 'karzo' ),
						'tab_icon' => [ 'value' => 'fas fa-star', 'library' => 'fa-solid' ],
						'tab_content' => __( 'We help ambitious businesses like yours generate more profits by building awareness, driving web traffic, connecting with customers, and growing overall sales. Give us a call.', 'karzo' ),
					],
				],
				'title_field' => '{{{ tab_title }}}',
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>

		<div class="dsvy-tabs">
			<?php if ( $settings['tabs'] ) : ?>
			<ul class="dsvy-tabs-heading">
				<?php $i = 1; foreach ( $settings['tabs'] as $tabs ) { ?>
					<?php $active_li_class = ( $i==1 ) ? 'dsvy-tab-li-active' : '' ; ?>

					<?php
					// icon
					$icon_html = '';
					if( !empty($tabs['tab_icon']['value']) ){
						if($tabs['tab_icon']['library']=='svg'){
							ob_start();
							Icons_Manager::render_icon( $tabs['tab_icon'] , [ 'aria-hidden' => 'true' ] );
							$icon_html = ob_get_contents();
							ob_end_clean();
							$icon_html       = '<div class="dsvy-tab-svg"><div class="dsvy-tab-svg-wrapper">' . $icon_html . '</div></div>';
							$icon_type_class = 'icon';
						} else {
							ob_start();
							Icons_Manager::render_icon( $tabs['tab_icon'] , [ 'aria-hidden' => 'true' ] );
							$icon_code = ob_get_contents();
							ob_end_clean();
							
							$icon_html = '<div class="dsvy-tab-icon">' . dsvy_esc_kses( $icon_code ) . '</div>';
							wp_enqueue_style( 'elementor-icons-'.$tabs['tab_icon']['library']);
						}
					}
					?>

				<li class="dsvy-tab-link <?php echo esc_attr($active_li_class); ?>" data-dsvy-tab="<?php echo esc_attr($i); ?>"><?php echo dsvy_esc_kses($icon_html); ?><span><?php echo esc_html($tabs['tab_title']); ?></span></li>
				<?php $i++; } ?>
			</ul>

			<div class="dsvy-tab-content-wrapper">
				<?php $j = 1; foreach ( $settings['tabs'] as $tabs ) { ?>
					<?php $active_class = ( $j==1 ) ? 'dsvy-tab-active' : '' ; ?>
					<div class="dsvy-tab-content dsvy-tab-content-<?php echo esc_attr($j); ?> <?php echo esc_attr($active_class); ?>">
						<?php
						$icon_html = ''; // icon
						if( !empty($tabs['tab_icon']['value']) ){
							if($tabs['tab_icon']['library']=='svg'){
								ob_start();
								Icons_Manager::render_icon( $tabs['tab_icon'] , [ 'aria-hidden' => 'true' ] );
								$icon_html = ob_get_contents();
								ob_end_clean();
								$icon_html       = '<div class="dsvy-tab-svg"><div class="dsvy-tab-svg-wrapper">' . $icon_html . '</div></div>';
								$icon_type_class = 'icon';
							} else {
								ob_start();
								Icons_Manager::render_icon( $tabs['tab_icon'] , [ 'aria-hidden' => 'true' ] );
								$icon_code = ob_get_contents();
								ob_end_clean();
								
								$icon_html = '<div class="dsvy-tab-icon">' . dsvy_esc_kses( $icon_code ) . '</div>';
								wp_enqueue_style( 'elementor-icons-'.$tabs['tab_icon']['library']);
							}
						}
						?>
						<div class="dsvy-tab-content-title" data-dsvy-tab="<?php echo esc_attr($j); ?>"><?php echo dsvy_esc_kses($icon_html); ?><?php echo esc_html($tabs['tab_title']); ?></div>
						<div class="dsvy-tab-content-inner">
							<?php echo dsvy_esc_kses($tabs['tab_content']); ?>
						</div>
					</div>
				<?php $j++; } ?>
			</div>

			<?php endif; ?>
	    </div>

	    <?php
	}

	protected function content_template() {}
}
// After the Schedule class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register( new DSVY_TabsElement() );